/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NotNull;

public class GraphBuilderFactoryImpl
extends GraphBuilderFactory {
    private final Project myProject;

    public GraphBuilderFactoryImpl(Project project2) {
        this.myProject = project2;
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull Graph2D graph, @NotNull Graph2DView view2, @NotNull GraphDataModel<N, E> dataModel, @NotNull GraphPresentationModel<N, E> presentationModel) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        if (dataModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataModel", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        if (presentationModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationModel", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        final GraphBuilderImpl<N, E> builder = new GraphBuilderImpl<N, E>(this.getProject(), graph, view2, dataModel, presentationModel);
        if (presentationModel instanceof BasicGraphPresentationModel) {
            ((BasicGraphPresentationModel)presentationModel).setGraphBuilder(builder);
            graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

                public void onGraph2DSelectionEvent(Graph2DSelectionEvent e2) {
                    if (e2.isNodeSelection()) {
                        builder.getGraphPresentationModel().onSelectionChanged(e2);
                    }
                }
            });
        }
        ((DefaultBackgroundRendererImpl)view2.getBackgroundRenderer()).setColor(JBColor.background());
        return builder;
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull GraphDataModel<N, E> dataModel, @NotNull GraphPresentationModel<N, E> presentationModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataModel", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        if (presentationModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationModel", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        return this.createGraphBuilder(GraphManager.getGraphManager().createGraph2D(), GraphManager.getGraphManager().createGraph2DView(), dataModel, presentationModel);
    }

    public <N, E> GraphBuilder createGraphBuilder(@NotNull GraphDataModel<N, E> dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataModel", "com/intellij/openapi/graph/impl/builder/GraphBuilderFactoryImpl", "createGraphBuilder"));
        }
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        return this.createGraphBuilder(graph, GraphManager.getGraphManager().createGraph2DView(), dataModel, (GraphPresentationModel<N, E>)new BasicGraphPresentationModel((Graph)graph));
    }

    public Project getProject() {
        return this.myProject;
    }
}

