/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.base.NodeMap;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphEventManager;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.layout.CanonicMultiStageLayouter;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.graph.impl.builder.GraphBuilderImpl");
    private final Graph2D myGraph;
    private final Graph2DView myView;
    private final Project myProject;
    private final GraphDataMaps<N, E> myGraphDataMaps;
    private final GraphUpdateModel myGraphUpdateModel;
    private final GraphDataModel<N, E> myGraphDataModel;
    private final GraphPresentationModel<N, E> myGraphPresentationModel;
    private final MergingUpdateQueue myMergingUpdateQueue;
    private Overview myOverview;
    private boolean myInitialized;
    private boolean myUpdating;
    private final EditMode myEditMode;
    private final HierarchyManager myHierarchyManager;
    private final List<CustomGraphUpdater> myUpdaters = new ArrayList<CustomGraphUpdater>();
    private boolean isDisposed = false;
    private GraphBuilderEventManager myEventManager;

    public GraphBuilderImpl(Project project2, Graph2D graph, Graph2DView view2, GraphDataModel<N, E> graphDataModel, GraphPresentationModel<N, E> graphPresentationModel) {
        this.myProject = project2;
        this.myGraph = graph;
        this.myView = view2;
        this.myGraphDataMaps = new GraphDataMaps(this.myGraph);
        this.myHierarchyManager = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.myGraphDataModel = graphDataModel;
        this.myGraphPresentationModel = graphPresentationModel;
        this.myGraphUpdateModel = new GraphUpdateModel((Graph)graph);
        this.myView.setGraph2D(this.getGraph());
        this.myEditMode = this.createEditMode();
        this.myMergingUpdateQueue = new MergingUpdateQueue("YFiles", 100, true, this.myView.getJComponent());
        this.myView.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.addDeleteDataProvider();
        this.myEventManager = new GraphEventManager(this.myEditMode, this);
        Disposer.register((Disposable)this, this.myGraphDataModel);
        Disposer.register((Disposable)this, this.myGraphPresentationModel);
        Disposer.register((Disposable)this, (Disposable)this.myMergingUpdateQueue);
    }

    public final void initialize() {
        this.initView();
        this.myInitialized = true;
        this.updateGraph();
    }

    public void updateGraph() {
        try {
            this.updateDataModel();
            this.updateView();
        }
        catch (ProcessCanceledException e2) {
            this.queueUpdate();
        }
    }

    public void updateDataModel() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.buildModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.removeOutdatedNodes((Graph)this.getGraph());
        this.removeOutdatedEdges((Graph)this.getGraph());
    }

    private void removeOutdatedEdges(Graph graph) {
        Set set2 = this.getDataMaps().getEdgeObjectDataMap().keySet();
        for (Edge edge : set2.toArray(new Edge[set2.size()])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void removeEdge(Graph graph, Edge edge) {
        this.getDataMaps().removeEdge(edge);
        if (graph.contains(edge)) {
            graph.removeEdge(edge);
        }
    }

    private void removeOutdatedNodes(Graph graph) {
        for (Node node : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node) && !this.isGroupNode(node)) {
                this.getDataMaps().removeNode(node);
                graph.removeNode(node);
            }
            if (!this.getHierarchyManager().isFolderNode(node)) continue;
            this.removeOutdatedNodes(this.getHierarchyManager().getInnerGraph(node));
            this.removeOutdatedEdges(this.getHierarchyManager().getInnerGraph(node));
        }
    }

    private void initView() {
        this.setDefaultSettings();
        this.getGraphPresentationModel().customizeSettings(this.getView(), this.myEditMode);
    }

    private void setDefaultSettings() {
        Graph2DView view2 = this.getView();
        this.myEditMode.allowResizeNodes(false);
        this.myEditMode.allowNodeCreation(false);
        this.myEditMode.showNodeTips(true);
        this.myEditMode.showEdgeTips(true);
        this.myEditMode.allowEdgeCreation(true);
        this.myEditMode.allowMoveLabels(false);
        this.myEditMode.allowMovePorts(false);
        this.myEditMode.allowMoveSelection(true);
        view2.setAntialiasedPainting(false);
        view2.setFitContentOnResize(true);
        view2.setGridVisible(false);
        view2.setGridResolution(20.0);
        view2.setGridColor(Color.LIGHT_GRAY);
        view2.setGridType(Graph2DView.GRID_POINTS);
        view2.addViewMode((ViewMode)this.myEditMode);
    }

    public Overview getOverview() {
        if (this.myOverview == null) {
            this.myOverview = GraphManager.getGraphManager().createOverview(this.getView());
        }
        return this.myOverview;
    }

    protected EditMode createEditMode() {
        GraphEditModeFactory factory2 = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = factory2.createEditMode(this);
        editMode.setPopupMode((ViewMode)factory2.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = factory2.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        return editMode;
    }

    public void updateView() {
        this.updateRealizers(false);
        this.updateEdgeLabels();
        this.updateGroups();
        this.layoutCreatedElements();
        for (CustomGraphUpdater updater : this.myUpdaters) {
            updater.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void updateRealizers(boolean updateAllNodes) {
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node) && (updateAllNodes || this.isNodeWasCreated(node))) {
                this.getGraph().setRealizer(node, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private void layoutCreatedElements() {
        List<Node> createdNodes = this.getCreatedNodes();
        List<Edge> createdEdges = this.getCreatedEdges();
        Layouter layouter = this.getCurrentLayouter();
        if (this.isIncrementalLayout() && layouter instanceof CanonicMultiStageLayouter) {
            CanonicMultiStageLayouter stageLayouter = (CanonicMultiStageLayouter)layouter;
            stageLayouter.setSubgraphLayouterEnabled(true);
            EdgeMap edgeMap = this.getGraph().createEdgeMap();
            NodeMap nodeMap = this.getGraph().createNodeMap();
            this.getGraph().addDataProvider(Layouter.SELECTED_NODES, (com.intellij.openapi.graph.base.DataProvider)nodeMap);
            this.getGraph().addDataProvider(Layouter.SELECTED_EDGES, (com.intellij.openapi.graph.base.DataProvider)edgeMap);
            for (Node node : createdNodes) {
                nodeMap.setBool((Object)node, true);
            }
            for (Edge edge : createdEdges) {
                edgeMap.setBool((Object)edge, true);
            }
            if (createdNodes.size() > 0 || createdEdges.size() > 0) {
                layouter.doLayout((LayoutGraph)this.getGraph());
                GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
                this.getGraph().updateViews();
            }
            stageLayouter.setSubgraphLayouterEnabled(false);
            this.getGraph().removeDataProvider(Layouter.SELECTED_NODES);
            this.getGraph().removeDataProvider(Layouter.SELECTED_EDGES);
        } else if (layouter != null && createdNodes.size() > 0) {
            this.doLayout(layouter);
        }
    }

    protected boolean isIncrementalLayout() {
        return false;
    }

    private List<Edge> getCreatedEdges() {
        ArrayList<Edge> createdEdges = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (!this.isEdgeWasCreated(edge)) continue;
            createdEdges.add(edge);
        }
        return createdEdges;
    }

    private List<Node> getCreatedNodes() {
        ArrayList<Node> createdNodes = new ArrayList<Node>();
        for (Node node : this.getGraph().getNodeArray()) {
            if (this.isGroupNode(node) || !this.isNodeWasCreated(node)) continue;
            createdNodes.add(node);
        }
        return createdNodes;
    }

    private void updateEdgeLabels() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabels;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.clearLabels(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabels = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private static void clearLabels(EdgeRealizer edgeRealizer) {
        for (int i2 = 0; i2 < edgeRealizer.labelCount(); ++i2) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i2));
        }
        edgeRealizer.setLabelText("");
    }

    private void doLayout(Layouter layouter) {
        this.doLayout(layouter, this.getGraph());
    }

    private void doLayout(Layouter layouter, Graph2D graph) {
        if (layouter == null) {
            return;
        }
        if (graph.getNodeArray().length > 0 && layouter.canLayout((LayoutGraph)graph)) {
            GraphManager graphManager = GraphManager.getGraphManager();
            graphManager.createBufferedLayouter(layouter).doLayout((LayoutGraph)graph);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.myUpdating;
    }

    public final synchronized void queueUpdate() {
        if (this.isUpdating()) {
            return;
        }
        final Cursor oldCursor = this.myView.getJComponent().getCursor();
        this.myView.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
        this.myUpdating = true;
        this.myMergingUpdateQueue.queue(new Update("Update"){

            public void run() {
                GraphBuilderImpl.this.updateGraph();
                GraphBuilderImpl.this.myUpdating = false;
                GraphBuilderImpl.this.myView.getJComponent().setCursor(oldCursor);
            }
        });
    }

    public GraphDataModel<N, E> getGraphDataModel() {
        return this.myGraphDataModel;
    }

    @NotNull
    public String getNodeName(Node node) {
        String string2 = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "getNodeName"));
        }
        return string2;
    }

    @Nullable
    public N getNodeObject(Node node) {
        return GraphImplUtil.getNodeObject(this.getDataMaps(), node);
    }

    @Nullable
    public E getEdgeObject(Edge edge) {
        return GraphImplUtil.getEdgeObject(this.getDataMaps(), edge);
    }

    public void buildModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        this.createDataModel();
    }

    public void createDataModel() {
        GraphDataModel<N, E> dataModel = this.getGraphDataModel();
        Collection nodes = dataModel.getNodes();
        for (Object nodeObject : nodes) {
            this.addNode(dataModel.getNodeName(nodeObject), nodeObject);
        }
        for (Object edgeObject : dataModel.getEdges()) {
            this.addEdge(dataModel.getSourceNode(edgeObject), dataModel.getTargetNode(edgeObject), dataModel.getEdgeName(edgeObject), edgeObject);
        }
    }

    private void updateGroups() {
        Collection<N> nodes = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap groupNodes = new HashMap();
        for (N nodeObject : nodes) {
            NodesGroup group = this.getGraphDataModel().getGroup(nodeObject);
            if (group == null) {
                Node node;
                Node node2 = this.getNode(nodeObject);
                if (node2 == null || this.getHierarchyManager().isRootGraph(node2.getGraph()) || (node = this.getHierarchyManager().getParentNode(node2)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(node)) {
                    Graph innerGraph = node2.getGraph();
                    NodeList list2 = graphManager.createNodeList();
                    for (Node innerNode : innerGraph.getNodeArray()) {
                        if (this.isGroupNode(innerNode)) continue;
                        list2.add((Object)innerNode);
                    }
                    this.getHierarchyManager().unfoldSubgraph(innerGraph, list2);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(node)) continue;
                NodeList list3 = graphManager.createNodeList();
                list3.add((Object)node2);
                this.getHierarchyManager().ungroupSubgraph(list3);
                continue;
            }
            if (groupNodes.get(group) == null) {
                groupNodes.put(group, new ArrayList());
            }
            ((ArrayList)groupNodes.get(group)).add(nodeObject);
        }
        ArrayList<Node> toToBeClosed = new ArrayList<Node>();
        for (NodesGroup group : groupNodes.keySet()) {
            boolean closed;
            Node groupNode = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.myHierarchyManager, group, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(groupNode);
            NodesGroup nodesGroup = GraphImplUtil.getGroup(this.getDataMaps(), groupNode);
            boolean bl = closed = nodesGroup != null ? nodesGroup.isClosed() : group.isClosed();
            if (closed && this.getHierarchyManager().isGroupNode(groupNode)) {
                toToBeClosed.add(groupNode);
            }
            NodeList list2 = graphManager.createNodeList();
            for (Object n2 : (ArrayList)groupNodes.get(group)) {
                list2.add((Object)this.getNode(n2));
            }
            if (list2.size() <= 0 || !this.myHierarchyManager.isGroupNode(groupNode)) continue;
            this.myHierarchyManager.groupSubgraph(list2, groupNode);
        }
        for (Node node : toToBeClosed) {
            try {
                this.myHierarchyManager.closeGroup(node);
                NodeRealizer gnr = this.getGraph().getRealizer(node);
                if (!(gnr instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)gnr).setGroupClosed(true);
                Graph graph = this.myHierarchyManager.getInnerGraph(node);
                if (!(graph instanceof Graph2D)) continue;
                this.doLayout(this.getCurrentLayouter(), (Graph2D)graph);
            }
            catch (Throwable t2) {
                LOG.error(t2);
            }
        }
        for (Iterator<Object> iterator2 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)iterator2) || !this.isGroupNode((Node)iterator2)) continue;
            this.getGraph().removeNode(iterator2);
        }
    }

    private boolean isGroupNode(Node node) {
        return this.myHierarchyManager.isFolderNode(node) || this.myHierarchyManager.isGroupNode(node);
    }

    private Layouter getCurrentLayouter() {
        return GraphSettingsProvider.getInstance((Project)this.getProject()).getSettings((Graph)this.getGraph()).getCurrentLayouter();
    }

    public void addNode(N nodeObject) {
        String nodeName = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(nodeName == null ? nodeObject.toString() : nodeName, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addNode"));
        }
        this.addNode(name, nodeObject, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject, Object ... equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addNode"));
        }
        Node node = GraphImplUtil.getExistedNode(this.getDataMaps(), name, equalityObjects);
        if (node != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName(this.getDataMaps(), node, name);
            }
        } else {
            node = GraphImplUtil.createNode((Graph)this.getGraph(), this.getInnerGraph(nodeObject), this.getDataMaps(), name, equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, nodeObject);
    }

    @Nullable
    private Graph getInnerGraph(N nodeObject) {
        NodesGroup group = this.getGraphDataModel().getGroup(nodeObject);
        if (group != null) {
            Node groupNode = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), group, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(groupNode)) {
                return this.getHierarchyManager().getInnerGraph(groupNode);
            }
        }
        return null;
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject1", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        if (nodeObject2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject2", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        return this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject) {
        if (nodeObject1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject1", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        if (nodeObject2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject2", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        return this.addEdge(nodeObject1, nodeObject2, name, edgeObject, edgeObject);
    }

    private Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject, Object ... equalityObjects) {
        if (nodeObject1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject1", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        if (nodeObject2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject2", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "addEdge"));
        }
        Node node1 = this.getOrCreateNode(nodeObject1);
        Node node2 = this.getOrCreateNode(nodeObject2);
        return this.createEdge(node1, node2, name, edgeObject, equalityObjects);
    }

    private Edge createEdge(@NotNull Node node1, @NotNull Node node2, @NotNull String name, E edgeObject, Object ... equalityObjects) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "createEdge"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "createEdge"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl", "createEdge"));
        }
        Edge edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node1, node2, name, equalityObjects);
        if (edge != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getDataMaps(), node1, node2, name, equalityObjects);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, edgeObject);
        return edge;
    }

    private Node getOrCreateNode(N nodeObject) {
        Node node = this.getNode(nodeObject);
        if (node == null) {
            this.addNode(nodeObject);
            node = this.getNode(nodeObject);
        }
        assert (node != null);
        return node;
    }

    public void dispose() {
        this.myMergingUpdateQueue.cancelAllUpdates();
        if (this.isDisposed) {
            return;
        }
        this.myGraphDataMaps.dispose();
        this.isDisposed = true;
    }

    @Nullable
    public String getNodeName(N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(N nodeObject) {
        return GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(E edgeObject) {
        return GraphImplUtil.getEdge(this.getDataMaps(), edgeObject);
    }

    public boolean isNodeWasCreated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasCreated(node);
    }

    public boolean isEdgeWasCreated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasUpdated(node);
    }

    public boolean isEdgeWasUpdated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    public final Graph2D getGraph() {
        return this.myGraph;
    }

    public Graph2DView getView() {
        return this.myView;
    }

    public Project getProject() {
        return this.myProject;
    }

    public GraphUpdateModel getGraphUpdateModel() {
        return this.myGraphUpdateModel;
    }

    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        return this.myGraphPresentationModel;
    }

    private boolean isInitialized() {
        return this.myInitialized;
    }

    private void addDeleteDataProvider() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (dataId.equals(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY)) {
                    return GraphBuilderImpl.this.getGraphPresentationModel().getDeleteProvider();
                }
                if (dataId.equals(GraphBuilder.GRAPH_BUILDER_KEY)) {
                    return GraphBuilderImpl.this;
                }
                return null;
            }
        });
    }

    public HierarchyManager getHierarchyManager() {
        return this.myHierarchyManager;
    }

    public void addCustomUpdater(CustomGraphUpdater updater) {
        this.myUpdaters.add(updater);
    }

    public EditMode getEditMode() {
        return this.myEditMode;
    }

    public GraphDataMaps<N, E> getDataMaps() {
        return this.myGraphDataMaps;
    }

    public Collection<N> getNodeObjects() {
        return this.getDataMaps().getNodeObjectDataMap().values();
    }

    public Collection<E> getEdgeObjects() {
        return this.getDataMaps().getEdgeObjectDataMap().values();
    }

    public boolean removeNode(N n2) {
        Node node = this.getNode(n2);
        if (node != null) {
            this.getDataMaps().removeNode(node);
            node.getGraph().removeNode(node);
            return true;
        }
        return false;
    }

    public boolean removeEdge(E e2) {
        Edge edge = this.getEdge(e2);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    public GraphBuilderEventManager getEventManager() {
        return this.myEventManager;
    }

    static {
        YBundlesInitializer.init();
    }
}

