/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GraphDataMaps<N, E> {
    private final BidirectionalMap<Node, N> myNodeObjectDataMap = new BidirectionalMap();
    private final BidirectionalMap<Edge, E> myEdgeObjectDataMap = new BidirectionalMap();
    private final Map<Node, ComparableNode> myNodeEqualityDataMap = new HashMap<Node, ComparableNode>();
    private final Map<Edge, ComparableEdge> myEdgeEqualityDataMap = new HashMap<Edge, ComparableEdge>();
    private final Map<Node, String> myNodeNameDataMap = new HashMap<Node, String>();
    private final Map<Edge, String> myEdgeNameDataMap = new HashMap<Edge, String>();
    private final Map<Node, NodesGroup> myNodeGroupDataMap = new HashMap<Node, NodesGroup>();
    private final List<Node> myDraggedNodesList = new ArrayList<Node>();
    private final Graph2D myGraph;

    public GraphDataMaps(Graph2D graph) {
        this.myGraph = graph;
    }

    @NotNull
    public BidirectionalMap<Node, N> getNodeObjectDataMap() {
        BidirectionalMap<Node, N> bidirectionalMap = this.myNodeObjectDataMap;
        if (bidirectionalMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getNodeObjectDataMap"));
        }
        return bidirectionalMap;
    }

    @NotNull
    public BidirectionalMap<Edge, E> getEdgeObjectDataMap() {
        BidirectionalMap<Edge, E> bidirectionalMap = this.myEdgeObjectDataMap;
        if (bidirectionalMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getEdgeObjectDataMap"));
        }
        return bidirectionalMap;
    }

    @NotNull
    public Map<Node, ComparableNode> getNodeEqualityDataMap() {
        Map<Node, ComparableNode> map2 = this.myNodeEqualityDataMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getNodeEqualityDataMap"));
        }
        return map2;
    }

    @NotNull
    public Map<Edge, ComparableEdge> getEdgeEqualityDataMap() {
        Map<Edge, ComparableEdge> map2 = this.myEdgeEqualityDataMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getEdgeEqualityDataMap"));
        }
        return map2;
    }

    @NotNull
    public Map<Node, String> getNodeNameDataMap() {
        Map<Node, String> map2 = this.myNodeNameDataMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getNodeNameDataMap"));
        }
        return map2;
    }

    @NotNull
    public Map<Edge, String> getEdgeNameDataMap() {
        Map<Edge, String> map2 = this.myEdgeNameDataMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getEdgeNameDataMap"));
        }
        return map2;
    }

    @NotNull
    public Map<Node, NodesGroup> getGroupNodeDataMap() {
        Map<Node, NodesGroup> map2 = this.myNodeGroupDataMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getGroupNodeDataMap"));
        }
        return map2;
    }

    @NotNull
    public List<Node> getDraggedNodesList() {
        List<Node> list2 = this.myDraggedNodesList;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphDataMaps", "getDraggedNodesList"));
        }
        return list2;
    }

    public Graph2D getGraph() {
        return this.myGraph;
    }

    public void removeNode(Node node) {
        this.myNodeObjectDataMap.remove((Object)node);
        this.myNodeEqualityDataMap.remove(node);
        this.myNodeNameDataMap.remove(node);
        this.myNodeGroupDataMap.remove(node);
    }

    public void removeEdge(Edge edge) {
        this.myEdgeObjectDataMap.remove((Object)edge);
        this.myEdgeEqualityDataMap.remove(edge);
        this.myEdgeNameDataMap.remove(edge);
    }

    public void dispose() {
        this.myNodeObjectDataMap.clear();
        this.myEdgeObjectDataMap.clear();
        this.myNodeEqualityDataMap.clear();
        this.myEdgeEqualityDataMap.clear();
        this.myNodeNameDataMap.clear();
        this.myEdgeNameDataMap.clear();
        this.myNodeGroupDataMap.clear();
        this.myDraggedNodesList.clear();
    }
}

