/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.BasicPopupMode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PopupMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class GraphEditModeFactoryImpl
extends GraphEditModeFactory {
    @Override
    public <N, E> EditMode createEditMode(final GraphBuilderImpl<N, E> builder) {
        final GraphPresentationModel<N, E> presentationModel = builder.getGraphPresentationModel();
        return new EditMode(){

            public String getNodeTip(Node node) {
                Object nodeObject = builder.getNodeObject(node);
                return nodeObject == null ? null : presentationModel.getNodeTooltip(nodeObject);
            }

            public String getEdgeTip(Edge edge) {
                Object edgeObject = builder.getEdgeObject(edge);
                return edgeObject == null ? null : presentationModel.getEdgeTooltip(edgeObject);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (!builder.isUpdating()) {
                        HitInfo info = this.getHitInfo(mouseEvent);
                        Node node = info.getHitNode();
                        Edge edge = info.getHitEdge();
                        if (node != null) {
                            Graph2D graph2D = builder.getGraph();
                            NodeRealizer gnr = graph2D.getRealizer(node);
                            if (gnr instanceof GroupNodeRealizer) {
                                GroupNodeRealizer realizer = (GroupNodeRealizer)gnr;
                                NodesGroup group = GraphImplUtil.getGroup(builder.getDataMaps(), node);
                                if (builder.getHierarchyManager().isFolderNode(node)) {
                                    builder.getHierarchyManager().openFolder(node);
                                    realizer.setGroupClosed(false);
                                    if (group != null) {
                                        group.setClosed(false);
                                    }
                                } else {
                                    builder.getHierarchyManager().closeGroup(node);
                                    realizer.setGroupClosed(true);
                                    if (group != null) {
                                        group.setClosed(true);
                                    }
                                    GraphViewUtil.setRenderedNodeSizes((Graph2D)builder.getGraph(), (Graph2DView)builder.getView(), (Node)node);
                                }
                                GraphViewUtil.updateWorldRect((Graph2DView)builder.getView());
                                builder.getGraph().updateViews();
                            }
                            super.mouseClicked(mouseEvent);
                        } else if (edge != null) {
                            presentationModel.editEdge(builder.getEdgeObject(edge));
                        }
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            public boolean editNode(Node node, EventObject eventObject) {
                Object nodeObject = builder.getNodeObject(node);
                return presentationModel.editNode(nodeObject) || super.editNode(node, eventObject);
            }
        };
    }

    @Override
    public <N, E> PopupMode createPopupMode(final GraphBuilderImpl<N, E> builder) {
        final GraphPresentationModel<N, E> presentationModel = builder.getGraphPresentationModel();
        return new BasicPopupMode(builder.getView(), presentationModel){

            @Override
            protected DefaultActionGroup getNodeActions(Node node) {
                return presentationModel.getNodeActionGroup(builder.getNodeObject(node));
            }

            @Override
            protected DefaultActionGroup getEdgeActions(Edge edge) {
                return presentationModel.getEdgeActionGroup(builder.getEdgeObject(edge));
            }

            @Override
            protected DefaultActionGroup getPaperPopupActions() {
                return presentationModel.getPaperActionGroup();
            }
        };
    }

    @Override
    public <N, E> CellEditorMode createCellEditorMode(GraphBuilderImpl<N, E> builder) {
        return new CellEditorMode(GraphEditModeFactoryImpl.getCellEditorDataProvider(builder), NodeCellRendererPainter.USER_DATA_MAP){};
    }

    private static <N, E> DataProvider getCellEditorDataProvider(final GraphBuilderImpl<N, E> builder) {
        return new DataProvider(){

            public Object get(Object dataHolder) {
                return builder.getGraphPresentationModel().getCustomNodeCellEditor(builder.getNodeObject((Node)dataHolder));
            }

            public int getInt(Object dataHolder) {
                return 0;
            }

            public double getDouble(Object dataHolder) {
                return 0.0;
            }

            public boolean getBool(Object dataHolder) {
                return false;
            }
        };
    }
}

