/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView view;
    private final EditMode editMode;
    private final ViewMode NAV_MODE = new NavigationMode();
    private final MagnifierViewMode ZOOM_MODE = new MagnifierViewMode();
    private volatile boolean isNavMode = false;
    private volatile boolean isZoomMode = false;
    private final List<GraphBuilderListener> listeners = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder builder;
    private boolean myNodeMoveFlag = false;

    GraphEventManager(EditMode mode, GraphBuilder builder) {
        this.builder = builder;
        this.view = builder.getView();
        this.editMode = mode;
        this.ZOOM_MODE.setMagnifierRadius(150);
        Disposer.register((Disposable)builder, (Disposable)this);
        JComponent canvas = this.view.getCanvasComponent();
        canvas.addMouseMotionListener((MouseMotionListener)((Object)this));
        canvas.addKeyListener((KeyListener)((Object)this));
        canvas.addMouseWheelListener((MouseWheelListener)((Object)this));
        canvas.addFocusListener((FocusListener)((Object)this));
        canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (GraphEventManager.this.myNodeMoveFlag) {
                    GraphEventManager.this.myNodeMoveFlag = false;
                    GraphEventManager.this.notifyListeners(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent e2) {
        if (e2.isControlDown() && !e2.isAltDown()) {
            this.setNavMode();
        } else if (e2.isAltDown() && !e2.isControlDown()) {
            this.setZoomMode();
        } else {
            if (!this.myNodeMoveFlag) {
                this.myNodeMoveFlag = true;
                this.notifyListeners(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.setEditMode();
        }
    }

    public void mouseMoved(MouseEvent e2) {
        if (!e2.isAltDown() && this.isZoomMode || !e2.isControlDown() && this.isNavMode) {
            this.setEditMode();
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        int key = e2.getKeyCode();
        boolean isAltDown = e2.isAltDown();
        boolean isControlDown = e2.isControlDown();
        if (isControlDown && GraphEventManager.isNavKey(key)) {
            this.moveNode(key);
        } else if (key == 17 && !isAltDown) {
            this.setNavMode();
        } else if (key == 18 && !isControlDown) {
            this.setZoomMode();
        } else {
            this.setEditMode();
        }
    }

    private void moveNode(int key) {
        Graph2D graph = this.view.getGraph2D();
        List nodes = GraphViewUtil.getSelectedNodes((Graph2D)graph);
        if (nodes.size() > 0) {
            this.notifyListeners(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : nodes) {
                NodeRealizer realizer = graph.getRealizer(node);
                realizer.setX(realizer.getX() + (double)(3 * (key == 37 ? -1 : (key == 39 ? 1 : 0))));
                realizer.setY(realizer.getY() + (double)(3 * (key == 38 ? -1 : (key == 40 ? 1 : 0))));
            }
            graph.updateViews();
            this.notifyListeners(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean isNavKey(int key) {
        return key == 37 || key == 39 || key == 40 || key == 38;
    }

    private synchronized void setNavMode() {
        if (!this.isNavMode) {
            this.view.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.editMode.setEditing(false);
            this.editMode.reactivateParent();
            this.isNavMode = true;
            this.view.removeViewMode((ViewMode)(this.isZoomMode ? this.ZOOM_MODE : this.editMode));
            this.isZoomMode = false;
            this.view.addViewMode(this.NAV_MODE);
        }
    }

    private synchronized void setZoomMode() {
        if (!this.isZoomMode) {
            this.isZoomMode = true;
            double zoom = this.view.getZoom();
            zoom = zoom < 1.0 ? 1.5 / zoom : 2.0 * zoom;
            this.ZOOM_MODE.setMagnifierZoomFactor(zoom);
            this.view.removeViewMode((ViewMode)(this.isNavMode ? this.NAV_MODE : this.editMode));
            this.isNavMode = false;
            this.view.addViewMode((ViewMode)this.ZOOM_MODE);
        }
    }

    private synchronized void setEditMode() {
        if (this.isNavMode) {
            this.notifyListeners(GraphBuilderEvent.GRAPH_MOVED, false);
            this.isNavMode = false;
            this.view.removeViewMode(this.NAV_MODE);
            this.view.addViewMode((ViewMode)this.editMode);
        } else if (this.isZoomMode) {
            this.isZoomMode = false;
            this.view.removeViewMode((ViewMode)this.ZOOM_MODE);
            this.view.updateView();
            this.view.addViewMode((ViewMode)this.editMode);
        }
    }

    public void keyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 17 || e2.getKeyCode() == 18) {
            this.setEditMode();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e2) {
        int sign = e2.getWheelRotation();
        if (sign == 0) {
            return;
        }
        if (e2.isControlDown()) {
            double zoom = this.view.getZoom() - (double)sign * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.view.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(zoom / this.view.getZoom(), e2.getPoint());
            }
        } else {
            Point viewPoint = this.view.getViewPoint();
            if (e2.isAltDown()) {
                this.view.setViewPoint((int)viewPoint.getX() + sign * 20, (int)viewPoint.getY());
            } else {
                this.view.setViewPoint((int)viewPoint.getX(), (int)viewPoint.getY() + sign * 20);
            }
            this.view.updateView();
        }
    }

    public double zoomView(double zoom) {
        this.notifyListeners(GraphBuilderEvent.ZOOM_CHANGED, true);
        double correctedZoom = Math.min(10.0, Math.max(zoom, 0.1));
        this.view.setZoom(correctedZoom);
        this.view.updateView();
        this.notifyListeners(GraphBuilderEvent.ZOOM_CHANGED, false);
        return correctedZoom;
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        this.setEditMode();
    }

    public void subscribe(GraphBuilderListener listener2) {
        if (!this.listeners.contains(listener2)) {
            this.listeners.add(listener2);
        }
    }

    public void dispose() {
        this.listeners.clear();
    }

    private void notifyListeners(GraphBuilderEvent event, boolean before) {
        for (GraphBuilderListener listener2 : this.listeners) {
            if (before) {
                listener2.beforeActionPerformed(this.builder, event);
                continue;
            }
            listener2.actionPerformed(this.builder, event);
        }
    }
}

