/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphImplUtil {
    public static Key NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");

    private GraphImplUtil() {
    }

    @Nullable
    public static Node getExistedNode(@NotNull GraphDataMaps dataMaps, @NotNull String name, Object[] equalityObjects) {
        if (dataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getExistedNode"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getExistedNode"));
        }
        ComparableNode comparableNode = GraphImplUtil.createComparableNode(name, equalityObjects);
        Map<Node, ComparableNode> equalityDataMap = dataMaps.getNodeEqualityDataMap();
        for (Node node : equalityDataMap.keySet()) {
            if (!comparableNode.equals(equalityDataMap.get(node))) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static <N, E> Edge getExistedEdge(GraphDataMaps<N, E> dataMaps, Node node1, Node node2, @NotNull String name, Object ... equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getExistedEdge"));
        }
        ComparableEdge comparableEdge = GraphImplUtil.createComparableEdge(dataMaps, name, node1, node2, equalityObjects);
        Map<Edge, ComparableEdge> equalityDataMap = dataMaps.getEdgeEqualityDataMap();
        for (Edge edge : equalityDataMap.keySet()) {
            if (!comparableEdge.equals(equalityDataMap.get(edge))) continue;
            return edge;
        }
        return null;
    }

    public static List<Node> getNodes(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> nodes = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        for (Node node : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node)) continue;
            nodes.addAll(GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node)));
        }
        return nodes;
    }

    public static List<Edge> getEdges(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> edges = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        for (Node node : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node)) continue;
            edges.addAll(GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node)));
        }
        return edges;
    }

    public static Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        if (dataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        return GraphImplUtil.createNode(graph, null, dataMaps, name, equalityObjects);
    }

    public static Node createNode(@NotNull Graph rootGraph, @Nullable Graph innerGraph, @NotNull GraphDataMaps dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (rootGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGraph", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        if (dataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createNode"));
        }
        Node node = innerGraph == null ? rootGraph.createNode() : innerGraph.createNode();
        GraphImplUtil.setNodeName(dataMaps, node, name);
        dataMaps.getNodeEqualityDataMap().put(node, GraphImplUtil.createComparableNode(name, equalityObjects));
        return node;
    }

    private static ComparableNode createComparableNode(@NotNull String name, Object ... equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createComparableNode"));
        }
        return new ComparableNode("", equalityObjects);
    }

    private static <N, E> ComparableEdge createComparableEdge(GraphDataMaps<N, E> graph, @NotNull String name, Node fromNode, Node toNode, Object ... equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createComparableEdge"));
        }
        return new ComparableEdge(name, GraphImplUtil.getComparableNode(graph, fromNode), GraphImplUtil.getComparableNode(graph, toNode), equalityObjects);
    }

    private static <N, E> ComparableNode getComparableNode(GraphDataMaps<N, E> dataMaps, Node fromNode) {
        return GraphImplUtil.createComparableNode(GraphImplUtil.getNodeName(dataMaps, fromNode), GraphImplUtil.getNodeComparableObject(dataMaps, fromNode));
    }

    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        if (graphDataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphDataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getNodeName"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getNodeName"));
        }
        String name = graphDataMaps.getNodeNameDataMap().get(node);
        String string2 = name == null ? "" : name;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getNodeName"));
        }
        return string2;
    }

    public static void setNodeName(GraphDataMaps dataMaps, Node node, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "setNodeName"));
        }
        dataMaps.getNodeNameDataMap().put(node, name);
    }

    public static <N, E> void setNodeObject(GraphDataMaps<N, E> graphDataMaps, Node node, N nodeObject) {
        graphDataMaps.getNodeObjectDataMap().put((Object)node, nodeObject);
    }

    public static <N, E> Node getOrCreateGroupNode(Graph2D graph, HierarchyManager hierarchyManager, NodesGroup group, GraphDataMaps<N, E> dataMaps) {
        Node existedNode = GraphImplUtil.findGroupNode(graph, group, hierarchyManager, dataMaps);
        if (existedNode != null) {
            return existedNode;
        }
        NodesGroup parent = group.getParent();
        if (parent != null) {
            Node parentNode = GraphImplUtil.findGroupNode(graph, parent, hierarchyManager, dataMaps);
            if (parentNode == null) {
                parentNode = GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, group.getParent(), dataMaps);
            }
            return GraphImplUtil.createGroupNode(hierarchyManager, graph, group, parentNode, dataMaps);
        }
        return GraphImplUtil.createGroupNode(hierarchyManager, graph, group, dataMaps);
    }

    @Nullable
    public static <N, E> NodesGroup getGroup(GraphDataMaps<N, E> dataMaps, Node groupNode) {
        return dataMaps.getGroupNodeDataMap().get(groupNode);
    }

    private static <N, E> Node createGroupNode(HierarchyManager hierarchyManager, Graph2D graph, NodesGroup group, GraphDataMaps<N, E> dataMaps) {
        return GraphImplUtil.createGroupNode(hierarchyManager, graph, group, null, dataMaps);
    }

    private static <N, E> Node createGroupNode(HierarchyManager hierarchyManager, Graph2D graph, NodesGroup group, Node parentNode, GraphDataMaps<N, E> dataMaps) {
        Node groupNode = parentNode == null ? hierarchyManager.createGroupNode((Graph)graph) : hierarchyManager.createGroupNode(parentNode);
        graph.setLabelText(groupNode, group.getGroupName());
        if (group.getGroupNodeRealizer() != null) {
            graph.setRealizer(groupNode, (NodeRealizer)group.getGroupNodeRealizer());
        }
        dataMaps.getGroupNodeDataMap().put(groupNode, group);
        return groupNode;
    }

    @Nullable
    private static <N, E> Node findGroupNode(Graph2D graph, @NotNull NodesGroup group, HierarchyManager hierarchyManager, GraphDataMaps<N, E> dataMaps) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "findGroupNode"));
        }
        for (Node node : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node) && !hierarchyManager.isGroupNode(node)) continue;
            if (group.equals(GraphImplUtil.getGroupNode(dataMaps, node))) {
                return node;
            }
            Node groupNode = GraphImplUtil.findChildrenGroupNode(group, hierarchyManager, graph, hierarchyManager.getChildren(node), dataMaps);
            if (groupNode == null) continue;
            return groupNode;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node findChildrenGroupNode(NodesGroup group, HierarchyManager hierarchyManager, Graph2D graph, NodeCursor children2, GraphDataMaps<N, E> dataMaps) {
        while (children2.ok()) {
            Node node = children2.node();
            if (group.equals(GraphImplUtil.getGroupNode(dataMaps, node))) {
                return node;
            }
            Node groupNode = GraphImplUtil.findChildrenGroupNode(group, hierarchyManager, graph, hierarchyManager.getChildren(node), dataMaps);
            if (groupNode != null) {
                return groupNode;
            }
            children2.next();
        }
        return null;
    }

    @Nullable
    public static <N, E> NodesGroup getGroupNode(GraphDataMaps<N, E> dataMaps, Node node) {
        return dataMaps.getGroupNodeDataMap().get(node);
    }

    public static <N, E> boolean isGroupNode(GraphDataMaps<N, E> dataMaps, Node node) {
        return dataMaps.getGroupNodeDataMap().get(node) != null;
    }

    public static <N, E> void setEdgeObject(GraphDataMaps<N, E> dataMaps, Edge edge, E edgeObject) {
        dataMaps.getEdgeObjectDataMap().put((Object)edge, edgeObject);
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E e2) {
        if (dataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getEdgeName"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getEdgeName"));
        }
        return dataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(dataMaps, e2));
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMaps", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getEdgeName"));
        }
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getEdgeName"));
        }
        String name = dataMaps.getEdgeNameDataMap().get(edge);
        return name == null ? "" : name;
    }

    public static <N, E> void setEdgeName(GraphDataMaps<N, E> dataMaps, Edge edge, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "setEdgeName"));
        }
        dataMaps.getEdgeNameDataMap().put(edge, name);
    }

    public static <N, E> Edge createEdge(GraphDataMaps<N, E> dataMaps, Node node1, Node node2, @NotNull String name, Object[] equalityObjects) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "createEdge"));
        }
        Edge edge = HierarchyManager.Statics.getInstance((Graph)dataMaps.getGraph()).createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put(edge, GraphImplUtil.createComparableEdge(dataMaps, name, node1, node2, equalityObjects));
        return edge;
    }

    @Nullable
    public static <N, E> N getNodeObject(GraphDataMaps<N, E> dataMaps, Node node) {
        return (N)dataMaps.getNodeObjectDataMap().get((Object)node);
    }

    @Nullable
    public static <N, E> E getEdgeObject(GraphDataMaps<N, E> dataMaps, Edge edge) {
        return (E)dataMaps.getEdgeObjectDataMap().get((Object)edge);
    }

    @Nullable
    public static <N, E> Node getNode(GraphDataMaps<N, E> dataMaps, N node) {
        return node == null ? null : (Node)ContainerUtil.getFirstItem((List)dataMaps.getNodeObjectDataMap().getKeysByValue(node));
    }

    @Nullable
    public static <N, E> Edge getEdge(GraphDataMaps<N, E> dataMaps, @NotNull E edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/impl/builder/GraphImplUtil", "getEdge"));
        }
        return (Edge)ContainerUtil.getFirstItem((List)dataMaps.getEdgeObjectDataMap().getKeysByValue(edge));
    }

    public static <N, E> void setNodeWasDragged(GraphDataMaps<N, E> dataMaps, Node node) {
        dataMaps.getDraggedNodesList().add(node);
    }

    public static <N, E> void updateDraggedNodesInfo(GraphBuilderImpl<N, E> builder) {
        GraphDataMaps<N, E> dataMaps = builder.getDataMaps();
        for (Node node : dataMaps.getGraph().getNodeArray()) {
            if (!dataMaps.getDraggedNodesList().contains(node)) continue;
            if ((builder.getGraphUpdateModel().isNodeWasUpdated(node) || builder.getGraphUpdateModel().isNodeWasCreated(node)) && !GraphImplUtil.isUpdatedNodeWasDragged(builder, node)) {
                builder.getGraphUpdateModel().setNodeWasViewed(node);
                dataMaps.getDraggedNodesList().remove(node);
                continue;
            }
            GraphImplUtil.setDraggedUpdateInfo(builder, node);
        }
    }

    private static boolean isUpdatedNodeWasDragged(GraphBuilderImpl builder, Node node) {
        return NODE_DRAGGED_INFO.equals(builder.getGraphUpdateModel().getNodeUpdatesDataMap().get((Object)node));
    }

    private static void setDraggedUpdateInfo(GraphBuilderImpl builder, Node node) {
        builder.getGraphUpdateModel().getNodeUpdatesDataMap().set((Object)node, (Object)NODE_DRAGGED_INFO);
    }

    private static <N, E> ComparableNode getNodeComparableObject(GraphDataMaps<N, E> dataMaps, Node node) {
        return dataMaps.getNodeEqualityDataMap().get(node);
    }
}

