/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeMap;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class GraphUpdateModel {
    public static Key NODE_UPDATE_INFO_DATA_PROVIDER = Key.create((String)"NODE_UPDATE_INFO_DATA_PROVIDER");
    public static Key EDGE_UPDATE_INFO_DATA_PROVIDER = Key.create((String)"EDGE_UPDATE_INFO_DATA_PROVIDER");
    public static Key CREATED_INFO = Key.create((String)"CREATED_INFO");
    public static Key SURVIVED_INFO = Key.create((String)"SURVIVED_INFO");
    private final Graph myGraph;

    public GraphUpdateModel(Graph graph) {
        this.myGraph = graph;
        this.createUpdateInfoDataProvider();
    }

    protected void createUpdateInfoDataProvider() {
        this.getGraph().addDataProvider((Object)NODE_UPDATE_INFO_DATA_PROVIDER, (DataProvider)this.getGraph().createNodeMap());
        this.getGraph().addDataProvider((Object)EDGE_UPDATE_INFO_DATA_PROVIDER, (DataProvider)this.getGraph().createEdgeMap());
    }

    public Graph getGraph() {
        return this.myGraph;
    }

    public void clearUpdateModel() {
        this.createUpdateInfoDataProvider();
    }

    public boolean isNodeWasCreated(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/graph/impl/builder/GraphUpdateModel", "isNodeWasCreated"));
        }
        return CREATED_INFO.equals(this.getNodeUpdatesDataMap().get((Object)node));
    }

    public boolean isEdgeWasCreated(@NotNull Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/impl/builder/GraphUpdateModel", "isEdgeWasCreated"));
        }
        return CREATED_INFO.equals(this.getEdgeUpdatesDataMap().get((Object)edge));
    }

    public boolean isNodeWasUpdated(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/graph/impl/builder/GraphUpdateModel", "isNodeWasUpdated"));
        }
        return this.getNodeUpdatesDataMap().get((Object)node) != null;
    }

    public boolean isEdgeWasUpdated(@NotNull Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/impl/builder/GraphUpdateModel", "isEdgeWasUpdated"));
        }
        return this.getEdgeUpdatesDataMap().get((Object)edge) != null;
    }

    public void setNodeWasCreated(Node node) {
        this.getNodeUpdatesDataMap().set((Object)node, (Object)CREATED_INFO);
    }

    public void setEdgeWasCreated(Edge edge) {
        this.getEdgeUpdatesDataMap().set((Object)edge, (Object)CREATED_INFO);
    }

    public void setNodeWasViewed(Node node) {
        this.getNodeUpdatesDataMap().set((Object)node, (Object)SURVIVED_INFO);
    }

    public void setEdgeWasViewed(Edge edge) {
        this.getEdgeUpdatesDataMap().set((Object)edge, (Object)SURVIVED_INFO);
    }

    public NodeMap getNodeUpdatesDataMap() {
        return (NodeMap)this.getGraph().getDataProvider((Object)NODE_UPDATE_INFO_DATA_PROVIDER);
    }

    public EdgeMap getEdgeUpdatesDataMap() {
        return (EdgeMap)this.getGraph().getDataProvider((Object)EDGE_UPDATE_INFO_DATA_PROVIDER);
    }

    public void dispose() {
    }
}

