/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import java.awt.Point;

public class NodeFactoryImpl
extends NodeFactory {
    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName) {
        Graph2D graph = builder.getGraph();
        Graph2DView view2 = builder.getView();
        GraphDataMaps dataMaps = ((GraphBuilderImpl)builder).getDataMaps();
        Node node = GraphImplUtil.createNode((Graph)graph, dataMaps, nodeName, nodeObject);
        GraphImplUtil.setNodeObject(dataMaps, node, nodeObject);
        builder.getGraph().setRealizer(node, builder.getGraphPresentationModel().getNodeRealizer(nodeObject));
        GraphViewUtil.setRenderedNodeSizes((Graph2D)graph, (Graph2DView)view2, (Node)node);
        return node;
    }

    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        Graph2D graph = builder.getGraph();
        Graph2DView view2 = builder.getView();
        Node node = this.createNode(builder, nodeObject, nodeName);
        graph.setLocation(node, view2.toWorldCoordX((int)location.getX()), view2.toWorldCoordY((int)location.getY()));
        return node;
    }

    public <N, E> Node createDraggedNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        Node node = this.createNode(builder, nodeObject, nodeName, location);
        GraphBuilderImpl graphBuilder = (GraphBuilderImpl)builder;
        GraphImplUtil.setNodeWasDragged(graphBuilder.getDataMaps(), node);
        builder.updateGraph();
        return node;
    }
}

