/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.ResourceBundle;
import y.option.OptionHandler;
import y.view.PrintPreviewPanel;

public class YBundlesInitializer {
    private static final Logger LOG = Logger.getInstance((String)YBundlesInitializer.class.getName());
    public static boolean isInitialized = false;
    public static final Map<Class, String> myClassesMap = new HashMap();

    private YBundlesInitializer() {
    }

    public static void init() {
        if (isInitialized) {
            return;
        }
        try {
            for (Class aClass : myClassesMap.keySet()) {
                String bundleName = aClass.getPackage().getName() + "." + myClassesMap.get(aClass);
                for (Field field : aClass.getDeclaredFields()) {
                    Type type = field.getGenericType();
                    if (!type.equals(ResourceBundle.class)) continue;
                    field.setAccessible(true);
                    field.set(null, ResourceBundle.getBundle(bundleName));
                }
            }
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
        isInitialized = true;
    }

    static {
        myClassesMap.put(OptionHandler.class, "OptionHandler");
        myClassesMap.put(PrintPreviewPanel.class, "PrintPreviewPanel");
    }
}

