/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder.dnd;

import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDHelper;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDSupport;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.psi.PsiElement;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewDnDHelperImpl
extends ProjectViewDnDHelper {
    public <N, E, T extends PsiElement> void addProjectViewDnDSupport(final GraphBuilder<N, E> builder, final ProjectViewDnDSupport<N, T> support) {
        new DropTarget(builder.getView().getCanvasComponent(), new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                List draggedFiles = this.getDraggableElements(dtde.getTransferable());
                if (draggedFiles.size() > 0 && support.acceptDraggedElements(draggedFiles)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                List nodeObjects = support.dropElements(this.getDraggableElements(dtde.getTransferable()));
                for (Object nodeObject : nodeObjects) {
                    if (this.isExistsNode(nodeObject)) continue;
                    NodeFactory.getInstance().createDraggedNode(builder, nodeObject, builder.getGraphDataModel().getNodeName(nodeObject), dtde.getLocation());
                }
                builder.updateGraph();
            }

            @NotNull
            private List<T> getDraggableElements(Transferable transferable) {
                ArrayList<PsiElement> arrayList;
                PsiElement[] psiElements;
                block9: {
                    psiElements = AbstractProjectViewPane.getTransferedPsiElements(transferable);
                    if (psiElements != null) break block9;
                    List list2 = Collections.emptyList();
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/dnd/ProjectViewDnDHelperImpl$1", "getDraggableElements"));
                    }
                    return list2;
                }
                try {
                    ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                    for (PsiElement psiElement : psiElements) {
                        try {
                            elements.add(psiElement);
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                    arrayList = elements;
                }
                catch (Exception exception) {
                    List list3 = Collections.emptyList();
                    if (list3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/dnd/ProjectViewDnDHelperImpl$1", "getDraggableElements"));
                    }
                    return list3;
                }
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/builder/dnd/ProjectViewDnDHelperImpl$1", "getDraggableElements"));
                }
                return arrayList;
            }

            private boolean isExistsNode(N nodeObject) {
                for (Node node : builder.getGraph().getNodeArray()) {
                    Object existed = builder.getNodeObject(node);
                    if (!nodeObject.equals(existed)) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

