/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder.util;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionNodeModeActionImpl
extends AbstractGraphToggleAction {
    private GraphBuilder myBuilder;

    public SelectionNodeModeActionImpl() {
        super(AllIcons.Graph.NodeSelectionMode);
    }

    public SelectionNodeModeActionImpl(GraphBuilder builder) {
        super(builder.getGraph(), AllIcons.Graph.NodeSelectionMode);
        this.myBuilder = builder;
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        GraphBuilder builder = this.getBuilder(e2);
        e2.getPresentation().setVisible(builder != null && builder.getGraphPresentationModel() instanceof SelectionDependenciesPresentationModel);
    }

    protected boolean isSelected(Graph2D graph, Project project2, AnActionEvent event) {
        GraphPresentationModel presentationModel;
        GraphBuilder builder = this.getBuilder(event);
        if (builder != null && (presentationModel = builder.getGraphPresentationModel()) instanceof SelectionDependenciesPresentationModel) {
            return ((SelectionDependenciesPresentationModel)presentationModel).isFilterDependenciesMode();
        }
        return false;
    }

    protected void setSelected(Graph2D graph, boolean state, Project project2, AnActionEvent e2) {
        GraphPresentationModel graphPresentationModel;
        GraphBuilder builder = this.getBuilder(e2);
        if (builder != null && (graphPresentationModel = builder.getGraphPresentationModel()) instanceof SelectionDependenciesPresentationModel) {
            ((SelectionDependenciesPresentationModel)graphPresentationModel).setFilterDependenciesMode(state);
        }
    }

    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/openapi/graph/impl/builder/util/SelectionNodeModeActionImpl", "getText"));
        }
        return ActionsBundle.message((String)"action.Graph.show.selected.node.dependencies.label", (Object[])new Object[0]);
    }

    @Nullable
    protected GraphBuilder getBuilder(AnActionEvent e2) {
        return this.myBuilder != null ? this.myBuilder : super.getBuilder(e2);
    }
}

