/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface BundledKeymapProvider {
    public static final ExtensionPointName<BundledKeymapProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledKeymapProvider");

    @NotNull
    public List<String> getKeymapFileNames();

    default public <R> R load(@NotNull String key, @NotNull Function<InputStream, R> consumer2) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/keymap/impl/BundledKeymapProvider", "load"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/keymap/impl/BundledKeymapProvider", "load"));
        }
        try (InputStream stream = URLUtil.openResourceStream((URL)new URL("file:///keymaps/" + key));){
            R r2 = consumer2.apply(stream);
            return r2;
        }
    }
}

