/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil");
    public static final String MAIN_MENU_TITLE = KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    public static final String MAIN_TOOLBAR = KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    public static final String EDITOR_POPUP = KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    public static final String EDITOR_TAB_POPUP = KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    public static final String FAVORITES_POPUP = KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    public static final String PROJECT_VIEW_POPUP = KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    public static final String COMMANDER_POPUP = KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    public static final String J2EE_POPUP = KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";
    @NonNls
    private static final String TOOL_ACTION_PREFIX = "Tool_";

    private ActionsTreeUtil() {
    }

    public static Map<String, String> createPluginActionsMap() {
        HashSet visited = ContainerUtil.newHashSet();
        HashMap result2 = ContainerUtil.newHashMap();
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            PluginId id = descriptor2.getPluginId();
            visited.add(id);
            if ("com.intellij".equals(id.getIdString())) continue;
            for (String actionId : ActionManagerEx.getInstanceEx().getPluginActions(id)) {
                result2.put(actionId, descriptor2.getName());
            }
        }
        for (PluginId id : PluginId.getRegisteredIds().values()) {
            if (visited.contains(id)) continue;
            for (String actionId : ActionManagerEx.getInstanceEx().getPluginActions(id)) {
                result2.put(actionId, id.getIdString());
            }
        }
        return result2;
    }

    private static Group createPluginsActionsGroup(Condition<AnAction> filtered) {
        AnAction anAction;
        String[] pluginActions;
        Group pluginGroup;
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        ArrayList plugins2 = new ArrayList();
        Collections.addAll(plugins2, PluginManagerCore.getPlugins());
        Collections.sort(plugins2, Comparator.comparing(IdeaPluginDescriptor::getName));
        ArrayList<PluginId> collected = new ArrayList<PluginId>();
        for (IdeaPluginDescriptor plugin : plugins2) {
            collected.add(plugin.getPluginId());
            if (plugin.getName().equals("IDEA CORE")) continue;
            pluginGroup = new Group(plugin.getName(), null, null);
            pluginActions = managerEx.getPluginActions(plugin.getPluginId());
            if (pluginActions.length == 0) continue;
            Arrays.sort(pluginActions, Comparator.comparing(ActionsTreeUtil::getTextToCompare));
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = managerEx.getActionOrStub(pluginAction);
                if (filtered != null && !filtered.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        for (PluginId pluginId : PluginId.getRegisteredIds().values()) {
            if (collected.contains(pluginId)) continue;
            pluginGroup = new Group(pluginId.getIdString(), null, null);
            pluginActions = managerEx.getPluginActions(pluginId);
            if (pluginActions.length == 0) continue;
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = managerEx.getActionOrStub(pluginAction);
                if (filtered != null && !filtered.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        return pluginsGroup;
    }

    private static Group createMainMenuGroup(Condition<AnAction> filtered) {
        Group group = new Group(MAIN_MENU_TITLE, "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)ActionManager.getInstance().getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group, filtered);
        return group;
    }

    @Nullable
    private static Condition<AnAction> wrapFilter(@Nullable Condition<AnAction> filter2, Keymap keymap, ActionManager actionManager) {
        ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        return action2 -> {
            String id;
            if (action2 == null) {
                return false;
            }
            String string2 = id = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id != null) {
                if (!Registry.is((String)"keymap.show.alias.actions")) {
                    boolean bound;
                    String binding = ActionsTreeUtil.getActionBinding(keymap, id);
                    boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id, keymap);
                    if (bound) {
                        return false;
                    }
                }
                if (!shortcutRestrictions.getForActionId((String)id).allowChanging) {
                    return false;
                }
            }
            return filter2 == null || filter2.value(action2);
        };
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id, Keymap keymap) {
        while (keymap != null) {
            if (((KeymapImpl)keymap).hasOwnActionId(id)) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup, Group group, Condition<AnAction> filtered) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action2 : mainMenuTopGroups = ActionsTreeUtil.getActions(actionGroup)) {
            Group subGroup;
            if (!(action2 instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered)).getSize() <= 0) continue;
            group.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, ActionsTreeUtil.getName((AnAction)actionGroup), null, null, ignore, filtered);
    }

    private static String getName(AnAction action2) {
        String id;
        String name = action2.getTemplatePresentation().getText();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String string2 = id = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
        if (id != null) {
            return id;
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action2;
            if (group.getChildrenCount() == 0) {
                return "Empty group";
            }
            for (AnAction child : children2 = group.getChildActionsOrStubs()) {
                if (child instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child);
            }
            return "Empty unnamed group";
        }
        return action2.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, groupName, icon, openIcon, ignore, filtered, true);
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group = new Group(groupName, actionManager.getId((AnAction)actionGroup), icon);
        for (AnAction action2 : children2 = ActionsTreeUtil.getActions(actionGroup)) {
            String id;
            if (action2 == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            if (action2 instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), null, null, ignore, filtered, normalizeSeparators);
                if (subGroup.getSize() > 0) {
                    if (!ignore && !((ActionGroup)action2).isPopup()) {
                        group.addAll(subGroup);
                        continue;
                    }
                    group.addGroup(subGroup);
                    continue;
                }
                if (filtered != null && !filtered.value((Object)action2)) continue;
                group.addGroup(subGroup);
                continue;
            }
            if (action2 instanceof Separator) {
                group.addSeparator();
                continue;
            }
            String string2 = id = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id == null || id.startsWith(TOOL_ACTION_PREFIX) || filtered != null && !filtered.value((Object)action2)) continue;
            group.addActionId(id);
        }
        if (normalizeSeparators) {
            group.normalizeSeparators();
        }
        return group;
    }

    private static Group createEditorActionsGroup(Condition<AnAction> filtered) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        ArrayList<String> ids = new ArrayList<String>();
        ActionsTreeUtil.addEditorActions(filtered, editorGroup, ids);
        Collections.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id : ids) {
            group.addActionId(id);
        }
        return group;
    }

    @Nullable
    private static String getActionBinding(Keymap keymap, String id) {
        if (keymap == null) {
            return null;
        }
        Keymap parent = keymap.getParent();
        String result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id);
        if (result2 == null && parent != null) {
            result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id);
        }
        return result2;
    }

    private static void addEditorActions(Condition<AnAction> filtered, DefaultActionGroup editorGroup, ArrayList<String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string2 = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || filtered != null && !filtered.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<AnAction> filtered, Project project2, KeymapExtension provider) {
        return (Group)provider.createGroup(filtered, project2);
    }

    private static Group createMacrosGroup(Condition<AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds("Macro.");
        Arrays.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (Object id : ids) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub((String)id))) continue;
            group.addActionId((String)id);
        }
        return group;
    }

    private static Group createQuickListsGroup(Condition<AnAction> filtered, String filter2, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, Comparator.comparing(QuickList::getActionId));
        Group group = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if ((filtered == null || !filtered.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) && !SearchUtil.isComponentHighlighted(quickList.getName(), filter2, forceFiltering, null) && (filtered != null || !StringUtil.isEmpty((String)filter2))) continue;
            group.addQuickList(quickList);
        }
        return group;
    }

    @NotNull
    private static Group createOtherGroup(@Nullable Condition<AnAction> filtered, Group addedActions, @Nullable Keymap keymap) {
        String[] registeredActionIds;
        addedActions.initIds();
        THashSet result2 = new THashSet();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (keymap != null) {
            for (String id : keymap.getActionIdList()) {
                if (id.startsWith(EDITOR_PREFIX) && actionManager.getActionOrStub("$" + id.substring(6)) != null || id.startsWith("QuickList.") || addedActions.containsId(id)) continue;
                result2.add(id);
            }
        }
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (String id : registeredActionIds = actionManager.getActionIds("")) {
            AnAction actionOrStub = actionManager.getActionOrStub(id);
            if (actionOrStub instanceof ActionGroup && !((ActionGroup)actionOrStub).canBePerformed(DataManager.getInstance().getDataContext()) || id.startsWith("QuickList.") || addedActions.containsId(id) || result2.contains(id) || keymapManager2.getBoundActions().contains(id)) continue;
            result2.add(id);
        }
        ActionsTreeUtil.filterOtherActionsGroup((Set<String>)result2);
        Group group = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
        AnAction[] groupedActions = ActionsTreeUtil.getActions("Other.KeymapGroup");
        for (AnAction action2 : groupedActions) {
            ActionsTreeUtil.addAction(group, action2, filtered);
        }
        result2.removeAll(group.initIds());
        for (String id : ContainerUtil.sorted((Collection)result2, (id1, id2) -> ActionsTreeUtil.getTextToCompare(id1).compareToIgnoreCase(ActionsTreeUtil.getTextToCompare(id2)))) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
            group.addActionId(id);
        }
        Group group2 = group;
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil", "createOtherGroup"));
        }
        return group2;
    }

    private static String getTextToCompare(String id) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(id);
        if (action2 == null) {
            return id;
        }
        String text2 = action2.getTemplatePresentation().getText();
        return text2 != null ? text2 : id;
    }

    private static void filterOtherActionsGroup(Set<String> actions2) {
        ActionsTreeUtil.filterOutGroup(actions2, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions2, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions2, "ChangeScheme");
    }

    private static void filterOutGroup(Set<String> actions2, String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(groupId);
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action2;
            for (AnAction child : children2 = group.getChildActionsOrStubs()) {
                String childId;
                String string2 = childId = child instanceof ActionStub ? ((ActionStub)child).getId() : actionManager.getId(child);
                if (childId == null) continue;
                if (child instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions2, childId);
                    continue;
                }
                actions2.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group);
        for (Object child : group.getChildren()) {
            if (child instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child);
                node.add(childNode);
                continue;
            }
            LOG.assertTrue(child != null);
            node.add(new DefaultMutableTreeNode(child));
        }
        return node;
    }

    public static Group createMainGroup(Project project2, Keymap keymap, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project2, keymap, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project2, Keymap keymap, QuickList[] quickLists, String filter2, boolean forceFiltering, Condition<AnAction> filtered) {
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered, keymap, ActionManager.getInstance());
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        for (KeymapExtension extension : (KeymapExtension[])Extensions.getExtensions((ExtensionPointName)KeymapExtension.EXTENSION_POINT_NAME)) {
            Group group = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project2, extension);
            if (group == null) continue;
            mainGroup.addGroup(group);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter2, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(wrappedFilter, mainGroup, keymap));
        if (!StringUtil.isEmpty((String)filter2) || filtered != null) {
            ArrayList<Object> list2 = mainGroup.getChildren();
            Iterator<Object> i2 = list2.iterator();
            while (i2.hasNext()) {
                Group group;
                Object o2 = i2.next();
                if (!(o2 instanceof Group) || (group = (Group)o2).getSize() != 0 || SearchUtil.isComponentHighlighted(group.getName(), filter2, forceFiltering, null)) continue;
                i2.remove();
            }
        }
        return mainGroup;
    }

    public static Condition<AnAction> isActionFiltered(String filter2, boolean force) {
        return action2 -> {
            String id;
            if (filter2 == null) {
                return true;
            }
            if (action2 == null) {
                return false;
            }
            action2 = ActionsTreeUtil.tryUnstubAction(action2);
            String insensitiveFilter = filter2.toLowerCase();
            ArrayList<String> options = new ArrayList<String>();
            options.add(action2.getTemplatePresentation().getText());
            options.add(action2.getTemplatePresentation().getDescription());
            String string2 = id = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            if (id != null) {
                options.add(id);
                options.addAll(AbbreviationManager.getInstance().getAbbreviations(id));
            }
            for (String text2 : options) {
                String lowerText;
                if (text2 == null || !SearchUtil.isComponentHighlighted(lowerText = text2.toLowerCase(), insensitiveFilter, force, null) && !lowerText.contains(insensitiveFilter)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap, Shortcut shortcut) {
        return action2 -> {
            Shortcut[] actionShortcuts;
            if (shortcut == null) {
                return true;
            }
            if (action2 == null) {
                return false;
            }
            for (Shortcut actionShortcut : actionShortcuts = keymap.getShortcuts(action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2))) {
                if (actionShortcut == null || !actionShortcut.startsWith(shortcut)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap, Shortcut shortcut, String filter2, boolean force) {
        return filter2 != null && filter2.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter2, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap, shortcut) : null);
    }

    public static void addAction(KeymapGroup group, AnAction action2, Condition<AnAction> filtered) {
        ActionsTreeUtil.addAction(group, action2, filtered, false);
    }

    public static void addAction(KeymapGroup group, AnAction action2, Condition<AnAction> filtered, boolean forceNonPopup) {
        if (action2 instanceof ActionGroup) {
            if (forceNonPopup) {
                AnAction[] actions2;
                for (AnAction childAction : actions2 = ActionsTreeUtil.getActions((ActionGroup)action2)) {
                    ActionsTreeUtil.addAction(group, childAction, filtered, true);
                }
            } else {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered);
                if (subGroup.getSize() > 0) {
                    group.addGroup((KeymapGroup)subGroup);
                }
            }
        } else if (action2 instanceof Separator) {
            if (group instanceof Group) {
                ((Group)group).addSeparator();
            }
        } else if (filtered == null || filtered.value((Object)action2)) {
            String id = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            group.addActionId(id);
        }
    }

    public static AnAction[] getActions(String actionGroup) {
        return ActionsTreeUtil.getActions((ActionGroup)ActionManager.getInstance().getActionOrStub(actionGroup));
    }

    public static AnAction[] getActions(ActionGroup group) {
        return group instanceof DefaultActionGroup ? ((DefaultActionGroup)group).getChildActionsOrStubs() : group.getChildren(null);
    }

    @NotNull
    private static AnAction tryUnstubAction(@NotNull AnAction action2) {
        AnAction newAction;
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil", "tryUnstubAction"));
        }
        if (action2 instanceof ActionStub && (newAction = ActionManager.getInstance().getActionOrStub(((ActionStub)action2).getId())) != null) {
            AnAction anAction = newAction;
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil", "tryUnstubAction"));
            }
            return anAction;
        }
        AnAction anAction = action2;
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil", "tryUnstubAction"));
        }
        return anAction;
    }
}

