/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class Group
implements KeymapGroup {
    private Group myParent;
    private final String myName;
    private String myId;
    private final Icon myIcon;
    private final ArrayList<Object> myChildren;
    private final Set<String> myIds = new HashSet<String>();

    public Group(String name, String id, Icon icon) {
        this.myName = name;
        this.myId = id;
        this.myIcon = icon;
        this.myChildren = new ArrayList();
    }

    public Group(String name, Icon icon) {
        this.myChildren = new ArrayList();
        this.myIcon = icon;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void addActionId(String id) {
        this.myChildren.add(id);
    }

    public void addQuickList(QuickList list2) {
        this.myChildren.add(list2);
    }

    public void addHyperlink(Hyperlink link) {
        this.myChildren.add(link);
    }

    public void addGroup(KeymapGroup keymapGroup) {
        Group group = (Group)keymapGroup;
        this.myChildren.add(group);
        group.myParent = this;
    }

    public void addSeparator() {
        this.myChildren.add(Separator.getInstance());
    }

    public boolean containsId(String id) {
        return this.myIds.contains(id);
    }

    public Set<String> initIds() {
        for (Object child : this.myChildren) {
            if (child instanceof String) {
                this.myIds.add((String)child);
                continue;
            }
            if (child instanceof QuickList) {
                this.myIds.add(((QuickList)child).getActionId());
                continue;
            }
            if (!(child instanceof Group)) continue;
            Group childGroup = (Group)child;
            this.myIds.addAll(childGroup.initIds());
            if (childGroup.myId == null) continue;
            this.myIds.add(childGroup.myId);
        }
        return this.myIds;
    }

    public ArrayList<Object> getChildren() {
        return this.myChildren;
    }

    public int getSize() {
        return this.myChildren.size();
    }

    public void normalizeSeparators() {
        while (this.myChildren.size() > 0 && this.myChildren.get(0) instanceof Separator) {
            this.myChildren.remove(0);
        }
        while (this.myChildren.size() > 0 && this.myChildren.get(this.myChildren.size() - 1) instanceof Separator) {
            this.myChildren.remove(this.myChildren.size() - 1);
        }
        for (int i2 = 1; i2 < this.myChildren.size() - 1; ++i2) {
            if (!(this.myChildren.get(i2) instanceof Separator) || !(this.myChildren.get(i2 + 1) instanceof Separator)) continue;
            this.myChildren.remove(i2);
            --i2;
        }
    }

    public String getActionQualifiedPath(String id) {
        Group cur = this.myParent;
        StringBuilder answer = new StringBuilder();
        while (cur != null && !cur.isRoot()) {
            answer.insert(0, cur.getName() + " | ");
            cur = cur.myParent;
        }
        String suffix = this.calcActionQualifiedPath(id);
        if (StringUtil.isEmpty((String)suffix)) {
            return null;
        }
        answer.append(suffix);
        return answer.toString();
    }

    private String calcActionQualifiedPath(String id) {
        if (!this.isRoot() && StringUtil.equals((CharSequence)id, (CharSequence)this.myId)) {
            return this.getName();
        }
        for (Object child : this.myChildren) {
            String path;
            if (child instanceof QuickList) {
                child = ((QuickList)child).getActionId();
            }
            if (child instanceof String) {
                if (!id.equals(child)) continue;
                AnAction action2 = ActionManager.getInstance().getActionOrStub(id);
                String path2 = action2 != null ? action2.getTemplatePresentation().getText() : id;
                return !this.isRoot() ? this.getName() + " | " + path2 : path2;
            }
            if (!(child instanceof Group) || (path = ((Group)child).calcActionQualifiedPath(id)) == null) continue;
            return !this.isRoot() ? this.getName() + " | " + path : path;
        }
        return null;
    }

    public boolean isRoot() {
        return this.myParent == null;
    }

    public String getQualifiedPath() {
        StringBuilder path = new StringBuilder(64);
        Group group = this;
        while (group != null && !group.isRoot()) {
            if (path.length() > 0) {
                path.insert(0, " | ");
            }
            path.insert(0, group.getName());
            group = group.myParent;
        }
        return path.toString();
    }

    public void addAll(Group group) {
        for (Object o2 : group.getChildren()) {
            if (o2 instanceof String) {
                this.addActionId((String)o2);
                continue;
            }
            if (o2 instanceof QuickList) {
                this.addQuickList((QuickList)o2);
                continue;
            }
            if (o2 instanceof Group) {
                this.addGroup((Group)o2);
                continue;
            }
            if (!(o2 instanceof Separator)) continue;
            this.addSeparator();
        }
    }

    public ActionGroup constructActionGroup(boolean popup2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup(this.getName(), popup2);
        AnAction groupToRestorePresentation = null;
        if (this.getName() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getName());
        } else if (this.getId() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getId());
        }
        if (groupToRestorePresentation != null) {
            group.copyFrom(groupToRestorePresentation);
        }
        for (Object o2 : this.myChildren) {
            if (o2 instanceof String) {
                group.add(actionManager.getAction((String)o2));
                continue;
            }
            if (o2 instanceof Separator) {
                group.addSeparator();
                continue;
            }
            if (!(o2 instanceof Group)) continue;
            group.add((AnAction)((Group)o2).constructActionGroup(popup2));
        }
        return group;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        if (group.getName() != null && this.getName() != null) {
            return group.getName().equals(this.getName());
        }
        if (this.getChildren() != null && group.getChildren() != null) {
            if (this.getChildren().size() != group.getChildren().size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
                if (this.getChildren().get(i2).equals(group.getChildren().get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

