/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ChooseActionsDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class QuickListPanel {
    private final CollectionListModel<Object> actionsModel;
    private JPanel myPanel;
    private final JBList myActionsList;
    JTextField myName;
    private JTextField myDescription;
    private JPanel myListPanel;
    QuickList item;

    public QuickListPanel(final @NotNull CollectionListModel<QuickList> model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/keymap/impl/ui/QuickListPanel", "<init>"));
        }
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.actionsModel = new CollectionListModel(objectArray);
        this.myActionsList = new JBList(this.actionsModel);
        this.myActionsList.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        this.myActionsList.getEmptyText().setText(KeyMapBundle.message((String)"no.actions", (Object[])new Object[0]));
        this.myActionsList.setEnabled(true);
        this.myListPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myActionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List items2 = model2.getItems();
                ChooseActionsDialog dialog2 = new ChooseActionsDialog((Component)QuickListPanel.this.myActionsList, KeymapManager.getInstance().getActiveKeymap(), items2.toArray(new QuickList[items2.size()]));
                if (dialog2.showAndGet()) {
                    String[] ids;
                    for (String id : ids = dialog2.getTreeSelectedActionIds()) {
                        QuickListPanel.this.includeActionId(id);
                    }
                    List list2 = QuickListPanel.this.actionsModel.getItems();
                    int size = list2.size();
                    ListSelectionModel selectionModel = QuickListPanel.this.myActionsList.getSelectionModel();
                    if (size > 0) {
                        selectionModel.removeIndexInterval(0, size - 1);
                    }
                    for (String id1 : ids) {
                        int idx = list2.lastIndexOf(id1);
                        if (idx < 0) continue;
                        selectionModel.addSelectionInterval(idx, idx);
                    }
                }
            }
        }).addExtraAction(new AnActionButton("Add Separator", AllIcons.General.SeparatorH){

            public void actionPerformed(@Nullable AnActionEvent e2) {
                QuickListPanel.this.actionsModel.add((Object)"QuickList.$Separator$");
            }
        }).setButtonComparator(new String[]{"Add", "Add Separator", "Remove", "Up", "Down"}).createPanel(), "Center");
    }

    public void apply() {
        String[] ids;
        if (this.item == null) {
            return;
        }
        this.item.setName(this.myName.getText().trim());
        this.item.setDescription(this.myDescription.getText().trim());
        ListModel model2 = this.myActionsList.getModel();
        int size = model2.getSize();
        if (size == 0) {
            ids = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            ids = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                ids[i2] = (String)model2.getElementAt(i2);
            }
        }
        this.item.setActionIds(ids);
    }

    public void setItem(@Nullable QuickList item) {
        this.apply();
        this.item = item;
        if (item == null) {
            return;
        }
        this.myName.setText(item.getName());
        this.myName.setEnabled(QuickListsManager.getInstance().getSchemeManager().isMetadataEditable(item));
        this.myDescription.setText(item.getDescription());
        this.actionsModel.removeAll();
        for (String id : item.getActionIds()) {
            this.includeActionId(id);
        }
    }

    private void includeActionId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/keymap/impl/ui/QuickListPanel", "includeActionId"));
        }
        if ("QuickList.$Separator$".equals(id) || this.actionsModel.getElementIndex((Object)id) == -1) {
            this.actionsModel.add((Object)id);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.display.name.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescription = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myName = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.description.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer", "getListCellRendererComponent"));
            }
            super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            Icon icon = null;
            String actionId = (String)value2;
            if ("QuickList.$Separator$".equals(actionId)) {
                this.setText("-------------");
            } else {
                Icon actionIcon;
                AnAction action2 = ActionManager.getInstance().getAction(actionId);
                this.setText(action2 != null ? action2.getTemplatePresentation().getText() : actionId);
                if (action2 != null && (actionIcon = action2.getTemplatePresentation().getIcon()) != null) {
                    icon = actionIcon;
                }
                if (actionId.startsWith("QuickList.")) {
                    icon = AllIcons.Actions.QuickList;
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
            }
            MyListCellRenderer myListCellRenderer = this;
            if (myListCellRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer", "getListCellRendererComponent"));
            }
            return myListCellRenderer;
        }
    }
}

