/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.WebProjectGenerator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebModuleBuilder
extends ModuleBuilder {
    public static final String GROUP_NAME = "Static Web";
    public static final Icon ICON = AllIcons.Nodes.PpWeb;
    private final WebProjectTemplate<?> myTemplate;

    public WebModuleBuilder(@NotNull WebProjectTemplate<?> template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/openapi/module/WebModuleBuilder", "<init>"));
        }
        this.myTemplate = template;
    }

    public WebModuleBuilder() {
        this.myTemplate = null;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        this.doAddContentEntry(modifiableRootModel);
    }

    public ModuleType getModuleType() {
        return WebModuleType.getInstance();
    }

    public String getPresentableName() {
        return this.getGroupName();
    }

    public boolean isTemplateBased() {
        return true;
    }

    public String getGroupName() {
        return GROUP_NAME;
    }

    public Icon getNodeIcon() {
        return this.myTemplate != null ? this.myTemplate.getIcon() : ICON;
    }

    @Nullable
    public Module commitModule(@NotNull Project project2, @Nullable ModifiableModuleModel model2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/WebModuleBuilder", "commitModule"));
        }
        Module module2 = super.commitModule(project2, model2);
        if (module2 != null && this.myTemplate != null) {
            WebModuleBuilder.doGenerate(this.myTemplate, module2);
        }
        return module2;
    }

    private static <T> void doGenerate(@NotNull WebProjectTemplate<T> template, @NotNull Module module2) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/openapi/module/WebModuleBuilder", "doGenerate"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/WebModuleBuilder", "doGenerate"));
        }
        WebProjectGenerator.GeneratorPeer<T> peer = template.getPeer();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
        VirtualFile dir = module2.getProject().getBaseDir();
        if (contentRoots.length > 0 && contentRoots[0] != null) {
            dir = contentRoots[0];
        }
        template.generateProject(module2.getProject(), dir, peer.getSettings(), module2);
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/openapi/module/WebModuleBuilder", "modifySettingsStep"));
        }
        if (this.myTemplate == null) {
            return super.modifySettingsStep(settingsStep);
        }
        final WebProjectGenerator.GeneratorPeer<?> peer = this.myTemplate.getPeer();
        peer.buildUI(settingsStep);
        return new ModuleWizardStep(){

            public JComponent getComponent() {
                return null;
            }

            public void updateDataModel() {
            }

            public boolean validate() throws ConfigurationException {
                ValidationInfo info = peer.validate();
                if (info != null) {
                    throw new ConfigurationException(info.message);
                }
                return true;
            }
        };
    }
}

