/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerComponent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/module/impl/ModuleFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener$Adapter;", "moduleManager", "Lcom/intellij/openapi/module/impl/ModuleManagerComponent;", "(Lcom/intellij/openapi/module/impl/ModuleManagerComponent;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "checkRootModification", "module", "Lcom/intellij/openapi/module/Module;", "newAncestorPath", "", "fileMoved", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "setModuleFilePath", "newFilePath", "lang-impl"})
public final class ModuleFileListener
extends BulkFileListener.Adapter {
    private final ModuleManagerComponent moduleManager;

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
            this.fileMoved((VFileMoveEvent)vFileEvent);
        }
    }

    private final void propertyChanged(VFilePropertyChangeEvent event) {
        if (!event.getFile().isDirectory() || event.getRequestor() instanceof StateStorage || Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") ^ true) {
            return;
        }
        Object object = event.getFile().getParent();
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Object parentPath = object;
        boolean someModulePathIsChanged = false;
        String newAncestorPath = (String)parentPath + "/" + event.getNewValue();
        Module[] moduleArray = this.moduleManager.getModules();
        for (int i2 = 0; i2 < moduleArray.length; ++i2) {
            String moduleFilePath;
            Module module2 = moduleArray[i2];
            if (!module2.isLoaded() || module2.isDisposed()) continue;
            String ancestorPath = (String)parentPath + "/" + event.getOldValue();
            if (FileUtil.isAncestor((String)ancestorPath, (String)(moduleFilePath = module2.getModuleFilePath()), (boolean)true)) {
                Module module3 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
                this.setModuleFilePath(module3, newAncestorPath + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
                someModulePathIsChanged = true;
            }
            if (!(Intrinsics.areEqual((Object)PathUtilRt.getParentPath((String)moduleFilePath), (Object)ancestorPath) ^ true)) continue;
            Module module4 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
            this.checkRootModification(module4, newAncestorPath);
        }
        if (someModulePathIsChanged) {
            this.moduleManager.incModificationCount();
        }
    }

    private final void fileMoved(VFileMoveEvent event) {
        if (!event.getFile().isDirectory()) {
            return;
        }
        CharSequence dirName = event.getFile().getNameSequence();
        String ancestorPath = event.getOldParent().getPath() + "/" + dirName;
        String newAncestorPath = event.getNewParent().getPath() + "/" + dirName;
        Module[] moduleArray = this.moduleManager.getModules();
        for (int i2 = 0; i2 < moduleArray.length; ++i2) {
            Module module2 = moduleArray[i2];
            if (!module2.isLoaded() || module2.isDisposed()) continue;
            String moduleFilePath = module2.getModuleFilePath();
            if (FileUtil.isAncestor((String)ancestorPath, (String)moduleFilePath, (boolean)true)) {
                Module module3 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
                this.setModuleFilePath(module3, event.getNewParent().getPath() + "/" + dirName + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
            }
            Module module4 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
            this.checkRootModification(module4, newAncestorPath);
        }
    }

    private final void checkRootModification(Module module2, String newAncestorPath) {
        String it;
        Object element$iv;
        int n2;
        ModuleRootManager moduleRootManager = ProjectKt.getRootManager(module2);
        if (!(moduleRootManager instanceof ModuleRootManagerImpl)) {
            moduleRootManager = null;
        }
        ModuleRootManagerImpl moduleRootManagerImpl = (ModuleRootManagerImpl)moduleRootManager;
        if (moduleRootManagerImpl == null) {
            return;
        }
        ModuleRootManagerImpl moduleRootManager2 = moduleRootManagerImpl;
        THashSet roots = new THashSet();
        Object[] $receiver$iv = moduleRootManager2.getContentRootUrls();
        for (n2 = 0; n2 < $receiver$iv.length; ++n2) {
            element$iv = $receiver$iv[n2];
            it = (String)element$iv;
            roots.add((Object)VfsUtilCore.urlToPath((String)it));
        }
        $receiver$iv = moduleRootManager2.getSourceRootUrls();
        for (n2 = 0; n2 < $receiver$iv.length; ++n2) {
            element$iv = $receiver$iv[n2];
            it = (String)element$iv;
            roots.add((Object)VfsUtilCore.urlToPath((String)it));
        }
        if (roots.contains((Object)newAncestorPath)) {
            moduleRootManager2.stateChanged();
        }
    }

    private final void setModuleFilePath(Module module2, String newFilePath) {
        ClasspathStorage.modulePathChanged(module2, newFilePath);
        ServiceKt.getStateStore((ComponentManager)module2).setPath(newFilePath);
    }

    public ModuleFileListener(@NotNull ModuleManagerComponent moduleManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleManager), (String)"moduleManager");
        this.moduleManager = moduleManager;
    }
}

