/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import org.jetbrains.annotations.NotNull;

public class LibraryScope
extends LibraryScopeBase {
    private final Library myLibrary;
    private final String myLibraryName;

    public LibraryScope(Project project2, Library library) {
        super(project2, library.getFiles(OrderRootType.CLASSES), library.getFiles(OrderRootType.SOURCES));
        this.myLibraryName = LibraryUtil.getPresentableName((Library)library);
        this.myLibrary = library;
    }

    @NotNull
    public String getDisplayName() {
        String string2 = "Library '" + this.myLibraryName + "'";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/LibraryScope", "getDisplayName"));
        }
        return string2;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        return this.myLibrary.equals(((LibraryScope)((Object)o2)).myLibrary);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myLibrary.hashCode();
    }
}

