/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.binding;

import com.intellij.openapi.options.binding.ValueAccessor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;

public abstract class BeanValueAccessor
extends ValueAccessor {
    protected final Object myBean;
    protected final String myPropertyName;

    public static BeanValueAccessor createAccessor(Object bean, String propertyName) {
        Field[] fields;
        for (final Field field : fields = bean.getClass().getFields()) {
            if (!field.getName().equals(propertyName)) continue;
            return new BeanValueAccessor(bean, propertyName){

                @Override
                protected Object doGetValue() throws IllegalAccessException {
                    return field.get(this.myBean);
                }

                @Override
                protected void doSetValue(Object value2) throws IllegalAccessException {
                    field.set(this.myBean, value2);
                }

                public Class getType() {
                    return field.getType();
                }
            };
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (final PropertyDescriptor descriptor2 : beanInfo.getPropertyDescriptors()) {
                if (!descriptor2.getName().equals(propertyName)) continue;
                return new BeanValueAccessor(bean, propertyName){

                    @Override
                    protected Object doGetValue() throws Exception {
                        return descriptor2.getReadMethod().invoke(this.myBean, new Object[0]);
                    }

                    @Override
                    protected void doSetValue(Object value2) throws Exception {
                        descriptor2.getWriteMethod().invoke(this.myBean, value2);
                    }

                    public Class getType() {
                        return descriptor2.getPropertyType();
                    }
                };
            }
            throw new IllegalArgumentException("Property " + propertyName + " not found in " + bean.getClass());
        }
        catch (IntrospectionException e2) {
            throw new RuntimeException(e2);
        }
    }

    public BeanValueAccessor(Object bean, String propertyName) {
        this.myBean = bean;
        this.myPropertyName = propertyName;
    }

    public Object getValue() {
        try {
            return this.doGetValue();
        }
        catch (Exception e2) {
            throw new RuntimeException("Cannot access property " + this.myPropertyName, e2);
        }
    }

    public void setValue(Object value2) {
        try {
            this.doSetValue(value2);
        }
        catch (Exception e2) {
            throw new RuntimeException("Cannot access property " + this.myPropertyName, e2);
        }
    }

    protected abstract Object doGetValue() throws Exception;

    protected abstract void doSetValue(Object var1) throws Exception;
}

