/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, @Nullable ConfigurableFilter filter2) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap idToConfigurable = ContainerUtil.newHashMap();
        ArrayList idsInEpOrder = ContainerUtil.newArrayList();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter2)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper.getId(), wrapper);
                idsInEpOrder.add(wrapper.getId());
                continue;
            }
            ContainerUtil.addIfNotNull(result2, (Object)configurable);
        }
        HashSet visited = ContainerUtil.newHashSet();
        Map<String, List<String>> idTree = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id, idToConfigurable, visited, idTree);
        }
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper);
        }
        return result2;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idTree", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        ConfigurableWrapper wrapper = idToConfigurable.get(id);
        if (visited.contains(id)) {
            ConfigurableWrapper configurableWrapper = wrapper;
            if (configurableWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
            }
            return configurableWrapper;
        }
        visited.add(id);
        List<String> childIds = idTree.get(id);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper = wrapper.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id, wrapper);
        }
        ConfigurableWrapper configurableWrapper = wrapper;
        if (configurableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        if (idsInEpOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idsInEpOrder", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        HashMap tree2 = ContainerUtil.newHashMap();
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper + ")");
                continue;
            }
            List children2 = (List)tree2.get(parentId);
            if (children2 == null) {
                children2 = ContainerUtil.newArrayListWithCapacity((int)5);
                tree2.put(parentId, children2);
            }
            children2.add(id);
        }
        HashMap hashMap = tree2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        return hashMap;
    }

    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project2, boolean withIdeSettings) {
        return ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(project2, withIdeSettings), project2);
    }

    public static ConfigurableGroup getConfigurableGroup(@NotNull List<Configurable> configurables, @Nullable Project project2) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "getConfigurableGroup"));
        }
        Map<String, List<Configurable>> map2 = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        HashMap tree2 = ContainerUtil.newHashMap();
        for (Map.Entry<String, List<Configurable>> entry : map2.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree2, project2, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree2, "root");
        if (!tree2.isEmpty()) {
            for (String groupId : tree2.keySet()) {
                LOG.warn("ignore group: " + groupId);
            }
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            SortedConfigurableGroup group;
            Configurable configurable = list2.get(i2);
            if (!(configurable instanceof SortedConfigurableGroup) || (configurable = ConfigurableExtensionPointUtil.getConfigurableToReplace(group.myList, (group = (SortedConfigurableGroup)configurable).getWeight())) == null) continue;
            list2.set(i2, configurable);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable = list2.get(0);
                if (configurable instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group = (SortedConfigurableGroup)configurable;
                    group.myWeight = weight;
                    return group;
                }
                if (configurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                    wrapper.myWeight = weight;
                    return wrapper;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree2, String groupId) {
        Node<SortedConfigurableGroup> node = tree2.remove(groupId);
        if (node.myChildren != null) {
            Iterator<Object> iterator2 = node.myChildren.iterator();
            while (iterator2.hasNext()) {
                String childId = (String)iterator2.next();
                ((SortedConfigurableGroup)node.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree2, childId));
                iterator2.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(Map<String, Node<SortedConfigurableGroup>> tree2, Project project2, String groupId, List<Configurable> configurables, ResourceBundle alternative) {
        String id = "configurable.group." + groupId;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.getBundle();
            if ("root".equals(groupId)) {
                try {
                    String value2 = bundle.getString("configurable.group.root.settings.display.name");
                    LOG.error("OptionsBundle does not contain root group", new String[]{value2});
                }
                catch (Exception exception) {
                    LOG.error("OptionsBundle does not contain root group", (Throwable)exception);
                }
            } else {
                LOG.warn("use other group instead of unexpected one: " + groupId);
                groupId = "other";
                id = "configurable.group." + groupId;
            }
        }
        Node node = Node.get(tree2, groupId);
        if (node.myValue == null) {
            int weight = ConfigurableExtensionPointUtil.getInt(bundle, id + ".settings.weight");
            String help = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.help.topic");
            String name = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.display.name");
            if (name != null && project2 != null) {
                if (!project2.isDefault() && !name.contains("{")) {
                    String named = ConfigurableExtensionPointUtil.getString(bundle, id + ".named.settings.display.name");
                    String string2 = name = named != null ? named : name;
                }
                if (name.contains("{")) {
                    name = StringUtil.first((String)MessageFormat.format(name, project2.getName()), (int)30, (boolean)true);
                }
            }
            node.myValue = new SortedConfigurableGroup(id, name, help, weight);
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables);
        }
        if (node.myParent == null && !groupId.equals("root")) {
            String parentId = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.parent");
            parentId = (String)Node.cyclic(tree2, parentId, "root", groupId, node);
            node.myParent = Node.add(tree2, parentId, groupId);
            ConfigurableExtensionPointUtil.addGroup(tree2, project2, parentId, null, bundle);
        }
    }

    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<Configurable> configurables) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "groupConfigurables"));
        }
        HashMap tree2 = ContainerUtil.newHashMap();
        for (Configurable configurable : configurables) {
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                String id = wrapper.getId();
                Node node = Node.get(tree2, id);
                if (node.myValue != null) {
                    LOG.warn("ignore configurable with duplicated id: " + id);
                    continue;
                }
                String parentId = wrapper.getParentId();
                String groupId = wrapper.getExtensionPoint().groupId;
                if (groupId != null) {
                    if (parentId != null) {
                        LOG.warn("ignore deprecated groupId: " + groupId + " for id: " + id);
                    } else {
                        parentId = groupId;
                    }
                }
                parentId = (String)Node.cyclic(tree2, parentId, "other", id, node);
                node.myParent = Node.add(tree2, parentId, node);
                node.myValue = wrapper;
                continue;
            }
            Node.add(tree2, "other", configurable);
        }
        HashMap map2 = ContainerUtil.newHashMap();
        for (String id : tree2.keySet().toArray(new String[tree2.size()])) {
            List<Configurable> list2;
            Node node = (Node)tree2.get(id);
            if (node == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables(tree2, node)) == null) continue;
            map2.put(id, list2);
            tree2.remove(id);
        }
        return map2;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree2, Node<ConfigurableWrapper> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return ContainerUtil.newArrayList();
            }
            return null;
        }
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)node.myChildren.size());
        Iterator<Object> iterator2 = node.myChildren.iterator();
        while (iterator2.hasNext()) {
            Object child = iterator2.next();
            if (child instanceof Configurable) {
                list2.add((Configurable)child);
            } else {
                Node value2 = (Node)child;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree2, value2) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add(value2.myValue);
                tree2.remove(((ConfigurableWrapper)value2.myValue).getId());
            }
            iterator2.remove();
        }
        if (node.myValue == null) {
            return list2;
        }
        for (Configurable configurable : list2) {
            node.myValue = ((ConfigurableWrapper)node.myValue).addChild(configurable);
        }
        return null;
    }

    private static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        Application application;
        ArrayList list2 = ContainerUtil.newArrayList();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            ConfigurableEP[] configurableEPArray = (ConfigurableEP[])application.getExtensions(Configurable.APPLICATION_CONFIGURABLE);
            int n2 = configurableEPArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConfigurableEP extension = configurableEPArray[i2];
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension), null);
            }
        }
        if (project2 != null && !project2.isDisposed()) {
            for (ConfigurableEP extension : (ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE)) {
                ConfigurableExtensionPointUtil.addValid(list2, (Configurable)ConfigurableWrapper.wrapConfigurable(extension), project2);
            }
        }
        return list2;
    }

    private static void addValid(List<Configurable> list2, Configurable configurable, Project project2) {
        if (ConfigurableExtensionPointUtil.isValid(configurable, project2)) {
            list2.add(configurable);
        }
    }

    private static boolean isValid(Configurable configurable, Project project2) {
        if (configurable == null) {
            return false;
        }
        OptionalConfigurable optional = ConfigurableWrapper.cast(OptionalConfigurable.class, (UnnamedConfigurable)configurable);
        if (optional != null && !optional.needDisplay()) {
            return false;
        }
        return project2 == null || !project2.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable);
    }

    @Nullable
    public static ResourceBundle getBundle(@NotNull String resource, @Nullable Iterable<Configurable> configurables, @Nullable ResourceBundle alternative) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "getBundle"));
        }
        ResourceBundle bundle = OptionsBundle.getBundle();
        if (ConfigurableExtensionPointUtil.getString(bundle, resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable : configurables) {
                ConfigurableWrapper wrapper;
                if (!(configurable instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    private static String getString(ResourceBundle bundle, String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleBase.replaceMnemonicAmpersand((String)bundle.getString(resource));
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, String resource) {
        try {
            String value2 = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value2 == null ? 0 : Integer.parseInt(value2);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter2) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter2 != null && !filter2.isIncluded(each);
    }

    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project2, @NotNull Class<T> configurableClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        T t2 = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), configurableClass);
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        return t2;
    }

    @NotNull
    public static <T extends Configurable> T findApplicationConfigurable(@NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        T t2 = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), configurableClass);
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        return t2;
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(ConfigurableEP<Configurable>[] extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            Configurable configurable2 = (Configurable)configurableClass.cast(configurable);
            if (configurable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findConfigurable"));
            }
            return (T)configurable2;
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project2, Class<? extends ConfigurableProvider> providerClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "createProjectConfigurableForProvider"));
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(ConfigurableEP<Configurable>[] extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(Map<I, Node<V>> tree2, I id) {
            Node<V> node = tree2.get(id);
            if (node == null) {
                node = new Node<V>();
                tree2.put(id, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(Map<I, Node<V>> tree2, I id, Object child) {
            Node<V> node = Node.get(tree2, id);
            if (node.myChildren == null) {
                node.myChildren = ContainerUtil.newArrayList();
            }
            node.myChildren.add(child);
            return node;
        }

        private static <I, V> boolean cyclic(Map<I, Node<V>> tree2, I id, Node<V> parent) {
            Node<V> node = tree2.get(id);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(Map<I, Node<V>> tree2, I id, I idDefault, I idNode, Node<V> parent) {
            if (id == null) {
                id = idDefault;
            }
            if (Node.cyclic(tree2, id, parent)) {
                LOG.warn("ignore cyclic dependency: " + id + " cannot contain " + idNode);
                id = idDefault;
            }
            return id;
        }
    }
}

