/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class PreferenceButton
extends JComponent {
    private final String myLabel;
    private final Icon myIcon;

    public PreferenceButton(String label, Icon icon) {
        this.myLabel = label;
        this.myIcon = icon;
        if (SystemInfo.isMac) {
            this.setFont(new Font("Lucida Grande", 0, 11));
        } else {
            this.setFont(UIUtil.getLabelFont());
        }
        this.setPreferredSize((Dimension)JBUI.size((int)100, (int)70));
        this.setOpaque(false);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Border border;
        Color bg = this.getBackground();
        if (bg == null) {
            bg = UIUtil.getPanelBackground();
        }
        g2.setColor(bg);
        if (this.isOpaque()) {
            g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        Insets insets = (border = this.getBorder()) == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(this);
        int x2 = (this.getWidth() - insets.left - insets.right - this.myIcon.getIconWidth()) / 2;
        int y2 = insets.top;
        this.myIcon.paintIcon(this, g2, x2, y2);
        g2.setFont(this.getFont());
        y2 += this.myIcon.getIconHeight();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        x2 = (this.getWidth() - insets.left - insets.right - metrics.stringWidth(this.myLabel)) / 2;
        y2 = (int)((double)y2 + 1.5 * (double)metrics.getHeight());
        g2.setColor(UIUtil.getLabelForeground());
        GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.drawString(this.myLabel, x2, y2);
    }
}

