/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PathReferenceProviderBase
implements PathReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.paths.PathReferenceProviderBase");

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/openapi/paths/PathReferenceProviderBase", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/openapi/paths/PathReferenceProviderBase", "createReferences"));
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        int offset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        String elementText = psiElement.getText();
        for (DynamicContextProvider provider : (DynamicContextProvider[])Extensions.getExtensions(DynamicContextProvider.EP_NAME)) {
            int dynamicOffset = provider.getOffset(psiElement, offset, elementText);
            if (dynamicOffset == -1) {
                return false;
            }
            if (dynamicOffset == offset) continue;
            offset = dynamicOffset;
        }
        int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
        if (pos != -1 && pos < endOffset) {
            endOffset = pos;
        }
        try {
            String text2 = elementText.substring(offset, endOffset);
            return this.createReferences(psiElement, offset, text2, references, soft);
        }
        catch (StringIndexOutOfBoundsException e2) {
            LOG.error("Cannot process string: '" + psiElement.getParent().getParent().getText() + "'", (Throwable)e2);
            return false;
        }
    }

    public abstract boolean createReferences(@NotNull PsiElement var1, int var2, String var3, @NotNull List<PsiReference> var4, boolean var5);

    public static int getLastPosOfURL(int offset, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/paths/PathReferenceProviderBase", "getLastPosOfURL"));
        }
        for (int i2 = offset; i2 < url.length(); ++i2) {
            switch (url.charAt(i2)) {
                case '#': 
                case '?': {
                    return i2;
                }
            }
        }
        return -1;
    }
}

