/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebReferencesAnnotatorBase
extends ExternalAnnotator<MyInfo[], MyInfo[]> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.paths.WebReferencesAnnotatorBase");
    private final Map<String, MyFetchCacheEntry> myFetchCache = new HashMap();
    private final Object myFetchCacheLock = new Object();
    private static final long FETCH_CACHE_TIMEOUT = 10000L;
    protected static final WebReference[] EMPTY_ARRAY = new WebReference[0];

    @NotNull
    protected abstract WebReference[] collectWebReferences(@NotNull PsiFile var1);

    @Nullable
    protected static WebReference lookForWebReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "lookForWebReference"));
        }
        return WebReferencesAnnotatorBase.lookForWebReference(Arrays.asList(element.getReferences()));
    }

    @Nullable
    private static WebReference lookForWebReference(Collection<PsiReference> references) {
        for (PsiReference reference : references) {
            WebReference webReference;
            if (reference instanceof WebReference) {
                return (WebReference)reference;
            }
            if (!(reference instanceof PsiDynaReference) || (webReference = WebReferencesAnnotatorBase.lookForWebReference(((PsiDynaReference)reference).getReferences())) == null) continue;
            return webReference;
        }
        return null;
    }

    public MyInfo[] collectInformation(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "collectInformation"));
        }
        WebReference[] references = this.collectWebReferences(file2);
        MyInfo[] infos = new MyInfo[references.length];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            WebReference reference = references[i2];
            infos[i2] = new MyInfo(PsiAnchor.create(reference.getElement()), reference.getRangeInElement(), reference.getValue());
        }
        return infos;
    }

    public MyInfo[] doAnnotate(MyInfo[] infos) {
        MyFetchResult[] fetchResults = new MyFetchResult[infos.length];
        for (int i2 = 0; i2 < fetchResults.length; ++i2) {
            fetchResults[i2] = this.checkUrl(infos[i2].myUrl);
        }
        boolean containsAvailableHosts = false;
        for (MyFetchResult fetchResult : fetchResults) {
            if (fetchResult == MyFetchResult.UNKNOWN_HOST) continue;
            containsAvailableHosts = true;
        }
        for (int i3 = 0; i3 < fetchResults.length; ++i3) {
            MyFetchResult result2 = fetchResults[i3];
            if (result2 != MyFetchResult.OK && (containsAvailableHosts || result2 != MyFetchResult.UNKNOWN_HOST)) continue;
            infos[i3].myResult = true;
        }
        return infos;
    }

    public void apply(@NotNull PsiFile file2, MyInfo[] infos, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "apply"));
        }
        if (infos == null || infos.length == 0) {
            return;
        }
        HighlightDisplayLevel displayLevel = this.getHighlightDisplayLevel((PsiElement)file2);
        for (MyInfo info : infos) {
            PsiElement element;
            if (info.myResult || (element = info.myAnchor.retrieve()) == null) continue;
            int start2 = element.getTextRange().getStartOffset();
            TextRange range = new TextRange(start2 + info.myRangeInElement.getStartOffset(), start2 + info.myRangeInElement.getEndOffset());
            String message2 = this.getErrorMessage(info.myUrl);
            Annotation annotation = displayLevel == HighlightDisplayLevel.ERROR ? holder.createErrorAnnotation(range, message2) : (displayLevel == HighlightDisplayLevel.WARNING ? holder.createWarningAnnotation(range, message2) : (displayLevel == HighlightDisplayLevel.WEAK_WARNING ? holder.createInfoAnnotation(range, message2) : holder.createWarningAnnotation(range, message2)));
            for (IntentionAction action2 : this.getQuickFixes()) {
                annotation.registerFix(action2);
            }
        }
    }

    @NotNull
    protected abstract String getErrorMessage(@NotNull String var1);

    @NotNull
    protected IntentionAction[] getQuickFixes() {
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "getQuickFixes"));
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    @NotNull
    protected abstract HighlightDisplayLevel getHighlightDisplayLevel(@NotNull PsiElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MyFetchResult checkUrl(String url) {
        Object object = this.myFetchCacheLock;
        // MONITORENTER : object
        MyFetchCacheEntry entry = this.myFetchCache.get(url);
        long currentTime = System.currentTimeMillis();
        if (entry != null && currentTime - entry.getTime() < 10000L) {
            MyFetchResult myFetchResult = entry.getFetchResult();
            // MONITOREXIT : object
            if (myFetchResult != null) return myFetchResult;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "checkUrl"));
        }
        MyFetchResult fetchResult = WebReferencesAnnotatorBase.doCheckUrl(url);
        this.myFetchCache.put(url, new MyFetchCacheEntry(currentTime, fetchResult));
        MyFetchResult myFetchResult = fetchResult;
        // MONITOREXIT : object
        if (myFetchResult != null) return myFetchResult;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "checkUrl"));
    }

    private static MyFetchResult doCheckUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/paths/WebReferencesAnnotatorBase", "doCheckUrl"));
        }
        if (url.startsWith("mailto")) {
            return MyFetchResult.OK;
        }
        try {
            HttpRequests.request((String)url).connectTimeout(3000).readTimeout(3000).tryConnect();
        }
        catch (UnknownHostException e2) {
            LOG.info((Throwable)e2);
            return MyFetchResult.UNKNOWN_HOST;
        }
        catch (HttpRequests.HttpStatusException e3) {
            LOG.info((Throwable)e3);
            return MyFetchResult.NONEXISTENCE;
        }
        catch (IOException e4) {
            LOG.info((Throwable)e4);
        }
        catch (IllegalArgumentException e5) {
            LOG.debug((Throwable)e5);
        }
        return MyFetchResult.OK;
    }

    protected static class MyInfo {
        final PsiAnchor myAnchor;
        final String myUrl;
        final TextRange myRangeInElement;
        volatile boolean myResult;

        private MyInfo(PsiAnchor anchor, TextRange rangeInElement, String url) {
            this.myAnchor = anchor;
            this.myRangeInElement = rangeInElement;
            this.myUrl = url;
        }
    }

    private static enum MyFetchResult {
        OK,
        UNKNOWN_HOST,
        NONEXISTENCE;

    }

    private static class MyFetchCacheEntry {
        private final long myTime;
        private final MyFetchResult myFetchResult;

        /*
         * WARNING - void declaration
         */
        private MyFetchCacheEntry(long time, @NotNull MyFetchResult myFetchResult) {
            void fetchResult;
            if (myFetchResult == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchResult", "com/intellij/openapi/paths/WebReferencesAnnotatorBase$MyFetchCacheEntry", "<init>"));
            }
            this.myTime = time;
            this.myFetchResult = fetchResult;
        }

        public long getTime() {
            return this.myTime;
        }

        @NotNull
        public MyFetchResult getFetchResult() {
            MyFetchResult myFetchResult = this.myFetchResult;
            if (myFetchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/paths/WebReferencesAnnotatorBase$MyFetchCacheEntry", "getFetchResult"));
            }
            return myFetchResult;
        }
    }
}

