/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDisposed;
    private DumbModeAction myDumbModeAction;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator", "<init>"));
        }
        this(task2.getProject(), (TaskInfo)task2, (PerformInBackgroundOption)task2);
        this.myDumbModeAction = task2.getDumbModeAction();
        if (this.myDumbModeAction == DumbModeAction.CANCEL) {
            task2.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    BackgroundableProcessIndicator.this.cancel();
                }

                public void exitDumbMode() {
                }
            });
        }
    }

    public BackgroundableProcessIndicator(final @Nullable Project project2, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator", "<init>"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator", "<init>"));
        }
        super(info.isCancellable(), true, project2, info.getCancelText());
        this.myDumbModeAction = DumbModeAction.NOTHING;
        if (project2 != null) {
            final ProjectManagerAdapter myListener2 = new ProjectManagerAdapter(){

                public void projectClosing(Project closingProject) {
                    if (BackgroundableProcessIndicator.this.isRunning()) {
                        BackgroundableProcessIndicator.this.cancel();
                    }
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(project2, (ProjectManagerListener)myListener2);
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    ProjectManager.getInstance().removeProjectManagerListener(project2, (ProjectManagerListener)myListener2);
                }
            });
        }
        this.setOwnerTask(info);
        this.setProcessId(info.getProcessId());
        this.myOption = option;
        this.myInfo = info;
        this.setTitle(info.getTitle());
        Project nonDefaultProject = project2 == null || project2.isDisposed() ? null : (project2.isDefault() ? null : project2);
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(nonDefaultProject);
        this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
        this.myBackgrounded = this.shouldStartInBackground();
        if (this.myBackgrounded) {
            this.doBackground();
        }
    }

    private boolean shouldStartInBackground() {
        return this.myOption.shouldStartInBackground() && this.myStatusBar != null;
    }

    public BackgroundableProcessIndicator(Project project2, final @Nls String progressTitle, @NotNull PerformInBackgroundOption option, final @Nls String cancelButtonText, final @Nls String backgroundStopTooltip, final boolean cancellable) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator", "<init>"));
        }
        this(project2, new TaskInfo(){

            public String getProcessId() {
                return "<unknown>";
            }

            @NotNull
            public String getTitle() {
                String string2 = progressTitle;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator$4", "getTitle"));
                }
                return string2;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }
        }, option);
    }

    @Deprecated
    public DumbModeAction getDumbModeAction() {
        return this.myDumbModeAction;
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        if (this.shouldStartInBackground()) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        this.myOption.processSentToBackground();
        this.doBackground();
        super.background();
    }

    private void doBackground() {
        if (this.myStatusBar != null) {
            this.myStatusBar.addProgress(this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }
}

