/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private final Set<PotemkinProgress> myEdtProgresses = ContainerUtil.newConcurrentSet();

    @Override
    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginalProgressIndicator()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        boolean edtProgress;
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "executeProcessUnderProgress"));
        }
        if (progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        boolean bl = edtProgress = progress instanceof PotemkinProgress && ApplicationManager.getApplication().isDispatchThread();
        if (edtProgress) {
            this.myEdtProgresses.add((PotemkinProgress)progress);
        }
        try {
            super.executeProcessUnderProgress(process2, progress);
        }
        finally {
            if (progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
            if (edtProgress) {
                this.myEdtProgresses.remove(progress);
            }
        }
    }

    public static void runWithAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runWithAlwaysCheckingCanceled"));
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task2, @Nullable JComponent parentComponent) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        long start2 = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task2, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task2.notifyFinished();
            long time = end - start2;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task2.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "systemNotify"));
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task2);
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)progressIndicator, null);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future2;
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task2, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final CoreProgressManager.TaskRunnable process2 = new CoreProgressManager.TaskRunnable((Task)task2, progressIndicator, continuation);
        CoreProgressManager.TaskContainer action2 = new CoreProgressManager.TaskContainer((Task)task2){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start2 = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e2) {
                    processCanceled = true;
                }
                catch (Throwable e3) {
                    exception = e3;
                }
                long end = System.currentTimeMillis();
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    Window window;
                    Task.NotificationInfo notificationInfo = task2.notifyFinished();
                    long time = end - start2;
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (task2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl$1", "lambda$run$0"));
                    }
                    CoreProgressManager.finishTask((Task)task2, finalCanceled, finalException);
                }, modalityState);
            }
        };
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread((Runnable)action2);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future2;
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runInReadActionWithWriteActionPriority"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new AssertionError((Object)"runInReadActionWithWriteActionPriority shouldn't be invoked from read action");
        }
        boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2);
        if (!success) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return success;
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        boolean hasEdtProgresses;
        boolean shouldSleep = HeavyProcessLatch.INSTANCE.hasPrioritizedThread() && Registry.is((String)"ide.prioritize.ui.thread", (boolean)false);
        boolean bl = hasEdtProgresses = !this.myEdtProgresses.isEmpty();
        if (shouldSleep && hasEdtProgresses) {
            return () -> this.pingProgresses() | ProgressManagerImpl.sleepIfNeededToGivePriorityToAnotherThread();
        }
        if (shouldSleep) {
            return ProgressManagerImpl::sleepIfNeededToGivePriorityToAnotherThread;
        }
        if (hasEdtProgresses) {
            return this::pingProgresses;
        }
        return null;
    }

    private boolean pingProgresses() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        boolean hasProgresses = false;
        for (PotemkinProgress progress : this.myEdtProgresses) {
            hasProgresses = true;
            progress.interact();
        }
        return hasProgresses;
    }

    private static boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (HeavyProcessLatch.INSTANCE.isInsideLowPriorityThread()) {
            LockSupport.parkNanos(1000000L);
            return true;
        }
        return false;
    }
}

