/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.CacheUpdateRunner");
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create((String)"FAILED_TO_INDEX");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();

    public static void processFiles(final ProgressIndicator indicator, boolean processInReadAction, Collection<VirtualFile> files2, Project project2, Consumer<FileContent> processor2) {
        indicator.checkCanceled();
        FileContentQueue queue2 = new FileContentQueue(files2, indicator);
        final double total = files2.size();
        queue2.startLoading();
        ProgressUpdater progressUpdater = new ProgressUpdater(){
            final Set<VirtualFile> myFilesBeingProcessed = new THashSet();
            final AtomicInteger myNumberOfFilesProcessed = new AtomicInteger();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingStarted(VirtualFile virtualFile) {
                indicator.checkCanceled();
                Set<VirtualFile> set2 = this.myFilesBeingProcessed;
                synchronized (set2) {
                    VirtualFile parent;
                    boolean added = this.myFilesBeingProcessed.add(virtualFile);
                    if (added) {
                        indicator.setFraction((double)this.myNumberOfFilesProcessed.incrementAndGet() / total);
                    }
                    if (added && (parent = virtualFile.getParent()) != null) {
                        indicator.setText2(parent.getPresentableUrl());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingSuccessfullyFinished(VirtualFile virtualFile) {
                Set<VirtualFile> set2 = this.myFilesBeingProcessed;
                synchronized (set2) {
                    boolean removed = this.myFilesBeingProcessed.remove(virtualFile);
                    assert (removed);
                }
            }
        };
        while (!project2.isDisposed()) {
            indicator.checkCanceled();
            if (!CacheUpdateRunner.processSomeFilesWhileUserIsInactive(queue2, progressUpdater, processInReadAction, project2, processor2)) continue;
        }
        if (project2.isDisposed()) {
            indicator.cancel();
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue2, @NotNull ProgressUpdater progressUpdater, boolean processInReadAction, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
        if (queue2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (fileProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/CacheUpdateRunner$3", "beforeWriteActionStart"));
                }
                innerIndicator.cancel();
            }
        };
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.addApplicationListener((ApplicationListener)canceller), ModalityState.any());
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = CacheUpdateRunner.indexingThreadCount();
            if (threadsCount == 1 || application.isWriteAccessAllowed()) {
                MyRunnable process2 = new MyRunnable(innerIndicator, queue2, isFinished, progressUpdater, processInReadAction, project2, fileProcessor);
                ProgressManager.getInstance().runProcess((Runnable)process2, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i2 = 0; i2 < threadsCount; ++i2) {
                    AtomicBoolean ref;
                    finishedRefs[i2] = ref = new AtomicBoolean();
                    MyRunnable process3 = new MyRunnable(innerIndicator, queue2, ref, progressUpdater, processInReadAction, project2, fileProcessor);
                    futures[i2] = application.executeOnPooledThread((Runnable)process3);
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished.get();
    }

    public static int indexingThreadCount() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(PROC_COUNT - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    private static boolean waitForAll(@NotNull AtomicBoolean[] finishedRefs, @NotNull Future<?>[] futures) {
        if (finishedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishedRefs", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        if (futures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "futures", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            for (Future<?> future2 : futures) {
                future2.get();
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (InterruptedException allFinished) {
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        return false;
    }

    private static class MyRunnable
    implements Runnable {
        private final ProgressIndicatorBase myInnerIndicator;
        private final FileContentQueue myQueue;
        private final AtomicBoolean myFinished;
        private final ProgressUpdater myProgressUpdater;
        private final boolean myProcessInReadAction;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Consumer<FileContent> myProcessor;

        public MyRunnable(@NotNull ProgressIndicatorBase innerIndicator, @NotNull FileContentQueue queue2, @NotNull AtomicBoolean finished2, @NotNull ProgressUpdater progressUpdater, boolean processInReadAction, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
            if (innerIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerIndicator", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (queue2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (finished2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finished", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (progressUpdater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (fileProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            this.myInnerIndicator = innerIndicator;
            this.myQueue = queue2;
            this.myFinished = finished2;
            this.myProgressUpdater = progressUpdater;
            this.myProcessInReadAction = processInReadAction;
            this.myProject = project2;
            this.myProcessor = fileProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.myProject.isDisposed() && !this.myInnerIndicator.isCanceled()) {
                try {
                    FileContent fileContent = this.myQueue.take(this.myInnerIndicator);
                    if (fileContent == null) {
                        this.myFinished.set(true);
                        return;
                    }
                    Runnable action2 = () -> {
                        this.myInnerIndicator.checkCanceled();
                        if (!this.myProject.isDisposed()) {
                            VirtualFile file2 = fileContent.getVirtualFile();
                            try {
                                this.myProgressUpdater.processingStarted(file2);
                                if (!file2.isDirectory() && !Boolean.TRUE.equals(file2.getUserData(FAILED_TO_INDEX))) {
                                    this.myProcessor.consume((Object)fileContent);
                                }
                                this.myProgressUpdater.processingSuccessfullyFinished(file2);
                            }
                            catch (ProcessCanceledException e2) {
                                throw e2;
                            }
                            catch (Throwable e3) {
                                MyRunnable.handleIndexingException(file2, e3);
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(() -> {
                            if (this.myProcessInReadAction) {
                                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(action2)) {
                                    throw new ProcessCanceledException();
                                }
                            } else {
                                action2.run();
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(this.myInnerIndicator));
                    }
                    catch (ProcessCanceledException e2) {
                        this.myQueue.pushBack(fileContent);
                        return;
                    }
                    finally {
                        this.myQueue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e3) {
                    return;
                }
            }
            return;
        }

        private static void handleIndexingException(VirtualFile file2, Throwable e2) {
            String message2 = "Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.err.println(message2);
                e2.printStackTrace();
            } else {
                LOG.error(message2, e2);
            }
            file2.putUserData(FAILED_TO_INDEX, (Object)Boolean.TRUE);
        }
    }

    static interface ProgressUpdater {
        public void processingStarted(VirtualFile var1);

        public void processingSuccessfullyFinished(VirtualFile var1);
    }
}

