/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.FileContentQueue");
    private static final long MAX_SIZE_OF_BYTES_IN_QUEUE = 0x100000L;
    private static final long PROCESSED_FILE_BYTES_THRESHOLD = 0x300000L;
    private static final long LARGE_SIZE_REQUEST_THRESHOLD = 2838528L;
    private static final int ourTasksNumber = SystemProperties.getBooleanProperty((String)"idea.allow.parallel.file.reading", (boolean)true) ? CacheUpdateRunner.indexingThreadCount() : 1;
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileContentQueue pool", (int)ourTasksNumber);
    private final LinkedBlockingDeque<FileContent> myLoadedContents;
    private final AtomicInteger myContentsToLoad;
    private final AtomicLong myLoadedBytesInQueue;
    private final Object myProceedWithLoadingLock;
    private volatile long myBytesBeingProcessed;
    private volatile boolean myLargeSizeRequested;
    private final Object myProceedWithProcessingLock;
    private final BlockingQueue<VirtualFile> myFilesQueue;
    private final ProgressIndicator myProgressIndicator;
    private static final Deque<FileContentQueue> ourContentLoadingQueues = new LinkedBlockingDeque<FileContentQueue>();

    public FileContentQueue(@NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator indicator) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/project/FileContentQueue", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "<init>"));
        }
        this.myLoadedContents = new LinkedBlockingDeque();
        this.myContentsToLoad = new AtomicInteger();
        this.myLoadedBytesInQueue = new AtomicLong();
        this.myProceedWithLoadingLock = new Object();
        this.myProceedWithProcessingLock = new Object();
        int numberOfFiles = files2.size();
        this.myContentsToLoad.set(numberOfFiles);
        this.myFilesQueue = numberOfFiles > 0 ? new ArrayBlockingQueue<VirtualFile>(numberOfFiles, false, files2) : null;
        this.myProgressIndicator = indicator;
    }

    public void startLoading() {
        if (this.myContentsToLoad.get() == 0) {
            return;
        }
        for (int i2 = 0; i2 < ourTasksNumber; ++i2) {
            ourContentLoadingQueues.addLast(this);
            Runnable task2 = () -> {
                FileContentQueue contentQueue = ourContentLoadingQueues.pollFirst();
                while (contentQueue != null) {
                    if (contentQueue.loadNextContent()) {
                        ourContentLoadingQueues.addLast(contentQueue);
                    }
                    contentQueue = ourContentLoadingQueues.pollFirst();
                }
            };
            ourExecutor.submit(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextContent() {
        VirtualFile file2 = (VirtualFile)this.myFilesQueue.poll();
        if (file2 == null || this.myProgressIndicator.isCanceled()) {
            return false;
        }
        try {
            this.myProgressIndicator.checkCanceled();
            this.myLoadedContents.offer(this.loadContent(file2, this.myProgressIndicator));
        }
        catch (ProcessCanceledException e2) {
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e3) {
            LOG.error((Throwable)e3);
        }
        finally {
            this.myContentsToLoad.addAndGet(-1);
        }
        return true;
    }

    private FileContent loadContent(@NotNull VirtualFile file2, @NotNull ProgressIndicator indicator) throws InterruptedException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/FileContentQueue", "loadContent"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "loadContent"));
        }
        FileContent content2 = new FileContent(file2);
        if (!FileContentQueue.isValidFile(file2) || !this.doLoadContent(content2, indicator)) {
            content2.setEmptyContent();
        }
        return content2;
    }

    private static boolean isValidFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/FileContentQueue", "isValidFile"));
        }
        return file2.isValid() && !file2.isDirectory() && !file2.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink((VirtualFile)file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadContent(@NotNull FileContent content2, @NotNull ProgressIndicator indicator) throws InterruptedException {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "doLoadContent"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "doLoadContent"));
        }
        long contentLength = content2.getLength();
        boolean counterUpdated = false;
        try {
            while (this.myLoadedBytesInQueue.get() > 0x100000L) {
                indicator.checkCanceled();
                Object object = this.myProceedWithLoadingLock;
                synchronized (object) {
                    this.myProceedWithLoadingLock.wait(300L);
                }
            }
            this.myLoadedBytesInQueue.addAndGet(contentLength);
            counterUpdated = true;
            content2.getBytes();
            return true;
        }
        catch (Throwable e2) {
            if (counterUpdated) {
                this.myLoadedBytesInQueue.addAndGet(-contentLength);
            }
            if (e2 instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e2;
            }
            if (e2 instanceof InterruptedException) {
                throw (InterruptedException)e2;
            }
            if (e2 instanceof IOException || e2 instanceof InvalidVirtualFileAccessException) {
                if (e2 instanceof FileNotFoundException) {
                    LOG.debug(e2);
                } else {
                    LOG.info(e2);
                }
            } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                e2.printStackTrace();
            } else {
                LOG.error(e2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileContent take(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "take"));
        }
        FileContent content2 = this.doTake(indicator);
        if (content2 == null) {
            return null;
        }
        long length = content2.getLength();
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e2) {
                this.pushBack(content2);
                throw e2;
            }
            Object object = this.myProceedWithProcessingLock;
            synchronized (object) {
                boolean requestingLargeSize;
                boolean bl = requestingLargeSize = length > 2838528L;
                if (requestingLargeSize) {
                    this.myLargeSizeRequested = true;
                }
                try {
                    if ((!this.myLargeSizeRequested || requestingLargeSize) && this.myBytesBeingProcessed + length <= Math.max(0x300000L, length)) {
                        this.myBytesBeingProcessed += length;
                        if (requestingLargeSize) {
                            this.myLargeSizeRequested = false;
                        }
                        return content2;
                    }
                    this.myProceedWithProcessingLock.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileContent doTake(ProgressIndicator indicator) {
        FileContent result2 = null;
        while (result2 == null) {
            try {
                int remainingContentsToLoad = this.myContentsToLoad.get();
                result2 = this.myLoadedContents.poll(50L, TimeUnit.MILLISECONDS);
                if (result2 != null) continue;
                if (remainingContentsToLoad == 0) {
                    return null;
                }
                indicator.checkCanceled();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        long loadedBytesInQueueNow = this.myLoadedBytesInQueue.addAndGet(-result2.getLength());
        if (loadedBytesInQueueNow < 0x100000L) {
            Object object = this.myProceedWithLoadingLock;
            synchronized (object) {
                this.myProceedWithLoadingLock.notifyAll();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull FileContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "release"));
        }
        Object object = this.myProceedWithProcessingLock;
        synchronized (object) {
            this.myBytesBeingProcessed -= content2.getLength();
            this.myProceedWithProcessingLock.notifyAll();
        }
    }

    public void pushBack(@NotNull FileContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "pushBack"));
        }
        this.myLoadedBytesInQueue.addAndGet(content2.getLength());
        this.myLoadedContents.addFirst(content2);
    }
}

