/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PathUtilEx {
    private static final Function<Module, Sdk> MODULE_JDK = module2 -> ModuleRootManager.getInstance((Module)module2).getSdk();
    private static final Convertor<Sdk, String> JDK_VERSION = new Convertor<Sdk, String>(){

        public String convert(Sdk jdk) {
            return StringUtil.notNullize((String)jdk.getVersionString());
        }
    };

    @Nullable
    public static Sdk getAnyJdk(Project project2) {
        return PathUtilEx.chooseJdk(project2, Arrays.asList(ModuleManager.getInstance((Project)project2).getModules()));
    }

    @Nullable
    public static Sdk chooseJdk(Project project2, Collection<Module> modules) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (projectJdk != null) {
            return projectJdk;
        }
        return PathUtilEx.chooseJdk(modules);
    }

    @Nullable
    public static Sdk chooseJdk(Collection<Module> modules) {
        List jdks = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Collection)ContainerUtil.skipNulls(modules), MODULE_JDK));
        if (jdks.isEmpty()) {
            return null;
        }
        Collections.sort(jdks, ComparatorUtil.compareBy(JDK_VERSION, (Comparator)String.CASE_INSENSITIVE_ORDER));
        return (Sdk)jdks.get(jdks.size() - 1);
    }
}

