/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkConfigurationUtil {
    private SdkConfigurationUtil() {
    }

    public static void createSdk(@Nullable Project project2, Sdk[] existingSdks, NullableConsumer<Sdk> onSdkCreatedCallBack, boolean createIfExists, SdkType ... sdkTypes) {
        SdkConfigurationUtil.createSdk(project2, existingSdks, onSdkCreatedCallBack, createIfExists, true, sdkTypes);
    }

    public static void createSdk(@Nullable Project project2, final Sdk[] existingSdks, final NullableConsumer<Sdk> onSdkCreatedCallBack, final boolean createIfExists, boolean followSymLinks, final SdkType ... sdkTypes) {
        if (sdkTypes.length == 0) {
            onSdkCreatedCallBack.consume(null);
            return;
        }
        FileChooserDescriptor descriptor2 = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        if (!followSymLinks) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        VirtualFile suggestedDir = SdkConfigurationUtil.getSuggestedSdkRoot(sdkTypes[0]);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                for (SdkType sdkType : sdkTypes) {
                    String path = selectedFiles.get(0).getPath();
                    if (!sdkType.isValidSdkHome(path)) continue;
                    Sdk newSdk = null;
                    if (!createIfExists) {
                        for (Sdk sdk : existingSdks) {
                            if (!path.equals(sdk.getHomePath())) continue;
                            newSdk = sdk;
                            break;
                        }
                    }
                    if (newSdk == null) {
                        newSdk = SdkConfigurationUtil.setupSdk(existingSdks, selectedFiles.get(0), sdkType, false, null, null);
                    }
                    onSdkCreatedCallBack.consume(newSdk);
                    return;
                }
                onSdkCreatedCallBack.consume(null);
            }

            public void cancelled() {
                onSdkCreatedCallBack.consume(null);
            }
        });
    }

    public static void createSdk(@Nullable Project project2, Sdk[] existingSdks, NullableConsumer<Sdk> onSdkCreatedCallBack, SdkType ... sdkTypes) {
        SdkConfigurationUtil.createSdk(project2, existingSdks, onSdkCreatedCallBack, true, sdkTypes);
    }

    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        return new FileChooserDescriptor(sdkTypes[0].getHomeChooserDescriptor()){

            public void validateSelectedFiles(VirtualFile[] files2) throws Exception {
                if (files2.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files2[0].getPath())) continue;
                        return;
                    }
                }
                String key = files2.length > 0 && files2[0].isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error";
                throw new Exception(ProjectBundle.message((String)key, (Object[])new Object[]{sdkTypes[0].getPresentableName()}));
            }
        };
    }

    public static void addSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "addSdk"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "lambda$addSdk$0"));
            }
            ProjectJdkTable.getInstance().addJdk(sdk);
        });
    }

    public static void removeSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(sdk));
    }

    @Nullable
    public static Sdk setupSdk(@NotNull Sdk[] allSdks, @NotNull VirtualFile homeDir, SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        ProjectJdkImpl sdk;
        if (allSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSdks", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "setupSdk"));
        }
        if (homeDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDir", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "setupSdk"));
        }
        try {
            sdk = SdkConfigurationUtil.createSdk(allSdks, homeDir, sdkType, additionalData, customSdkSuggestedName);
            sdkType.setupSdkPaths((Sdk)sdk);
        }
        catch (Exception e2) {
            if (!silent) {
                Messages.showErrorDialog((String)("Error configuring SDK: " + e2.getMessage() + ".\nPlease make sure that " + FileUtil.toSystemDependentName((String)homeDir.getPath()) + " is a valid home path for this SDK type."), (String)"Error Configuring SDK");
            }
            return null;
        }
        return sdk;
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Sdk[] allSdks, @NotNull VirtualFile homeDir, SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (allSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSdks", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createSdk"));
        }
        if (homeDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDir", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createSdk"));
        }
        List<Sdk> sdksList = Arrays.asList(allSdks);
        String sdkPath = sdkType.sdkPath(homeDir);
        String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, sdkPath, sdksList) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, sdksList);
        ProjectJdkImpl sdk = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType);
        if (additionalData != null) {
            sdk.setSdkAdditionalData(additionalData);
        }
        sdk.setHomePath(sdkPath);
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createSdk"));
        }
        return projectJdkImpl;
    }

    public static void setDirectoryProjectSdk(@NotNull Project project2, @Nullable Sdk sdk) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "setDirectoryProjectSdk"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "lambda$setDirectoryProjectSdk$2"));
            }
            ProjectRootManager.getInstance((Project)project2).setProjectSdk(sdk);
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            if (modules.length > 0) {
                ModuleRootModificationUtil.setSdkInherited((Module)modules[0]);
            }
        });
    }

    public static void configureDirectoryProjectSdk(Project project2, @Nullable Comparator<Sdk> preferredSdkComparator, SdkType ... sdkTypes) {
        Sdk existingSdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (existingSdk != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk = SdkConfigurationUtil.findOrCreateSdk(preferredSdkComparator, sdkTypes);
        if (sdk != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project2, sdk);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(@Nullable Comparator<Sdk> comparator2, SdkType ... sdkTypes) {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        if (sdk != null) {
            for (SdkType type : sdkTypes) {
                if (sdk.getSdkType() != type) continue;
                return sdk;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type);
            if (sdks.isEmpty()) continue;
            if (comparator2 != null) {
                Collections.sort(sdks, comparator2);
            }
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            Sdk an_sdk;
            String suggestedHomePath = sdkType.suggestHomePath();
            if (suggestedHomePath == null || !sdkType.isValidSdkHome(suggestedHomePath) || (an_sdk = SdkConfigurationUtil.createAndAddSDK(suggestedHomePath, sdkType)) == null) continue;
            return an_sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk createAndAddSDK(String path, SdkType sdkType) {
        VirtualFile sdkHome = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        if (sdkHome != null) {
            Sdk newSdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, sdkType, true, null, null);
            if (newSdk != null) {
                SdkConfigurationUtil.addSdk(newSdk);
            }
            return newSdk;
        }
        return null;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull SdkType type, String home, Collection<Sdk> sdks) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createUniqueSdkName"));
        }
        String string2 = SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createUniqueSdkName"));
        }
        return string2;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull String suggestedName, @NotNull Collection<Sdk> sdks) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createUniqueSdkName"));
        }
        if (sdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createUniqueSdkName"));
        }
        HashSet<String> names = new HashSet<String>();
        for (Sdk jdk : sdks) {
            names.add(jdk.getName());
        }
        String newSdkName = suggestedName;
        int i2 = 0;
        while (names.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i2 + ")";
        }
        String string2 = newSdkName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "createUniqueSdkName"));
        }
        return string2;
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @NotNull Consumer<String> consumer2) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "selectSdkHome"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "selectSdkHome"));
        }
        FileChooserDescriptor descriptor2 = sdkType.getHomeChooserDescriptor();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdkType);
            if (sdk == null) {
                throw new RuntimeException("No SDK of type " + sdkType + " found");
            }
            consumer2.consume((Object)sdk.getHomePath());
            return;
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, (VirtualFile)SdkConfigurationUtil.getSuggestedSdkRoot(sdkType), chosen -> {
            if (sdkType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "lambda$selectSdkHome$4"));
            }
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "lambda$selectSdkHome$4"));
            }
            String path = ((VirtualFile)chosen.get(0)).getPath();
            if (sdkType.isValidSdkHome(path)) {
                consumer2.consume((Object)path);
                return;
            }
            String adjustedPath = sdkType.adjustSelectedSdkHome(path);
            if (sdkType.isValidSdkHome(adjustedPath)) {
                consumer2.consume((Object)adjustedPath);
            }
        });
    }

    @Nullable
    public static VirtualFile getSuggestedSdkRoot(@NotNull SdkType sdkType) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "getSuggestedSdkRoot"));
        }
        String homePath = sdkType.suggestHomePath();
        return homePath == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
    }

    @NotNull
    public static List<String> filterExistingPaths(@NotNull SdkType sdkType, Collection<String> sdkHomes, Sdk[] sdks) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "filterExistingPaths"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (SdkConfigurationUtil.findByPath(sdkType, sdks, sdkHome) != null) continue;
            result2.add(sdkHome);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "filterExistingPaths"));
        }
        return arrayList;
    }

    @Nullable
    private static Sdk findByPath(@NotNull SdkType sdkType, @NotNull Sdk[] sdks, @NotNull String sdkHome) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "findByPath"));
        }
        if (sdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "findByPath"));
        }
        if (sdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHome", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil", "findByPath"));
        }
        for (Sdk sdk : sdks) {
            String path = sdk.getHomePath();
            if (sdk.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome))) continue;
            return sdk;
        }
        return null;
    }
}

