/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    private final VirtualFileFilter myContentFilter;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeManager", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        this.myContentFilter = file2 -> {
            assert (file2 != null);
            return (Boolean)ReadAction.compute(() -> !this.isScopeDisposed() && this.isInContent(file2));
        };
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2, @NotNull VirtualFileFilter customFilter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        if (customFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customFilter", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor2, file2 -> {
            if (customFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customFilter", "com/intellij/openapi/roots/impl/FileIndexBase", "lambda$iterateContentUnderDirectory$2"));
            }
            return this.myContentFilter.accept(file2) && customFilter.accept(file2);
        });
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor2, this.myContentFilter);
    }

    private static boolean iterateContentUnderDirectoryWithFilter(@NotNull VirtualFile dir, @NotNull ContentIterator iterator2, @NotNull VirtualFileFilter filter2) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)filter2, (ContentIterator)iterator2);
    }

    @NotNull
    protected DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        return directoryInfo;
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "isContentSourceFile"));
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    @NotNull
    protected static VirtualFile[][] getModuleContentAndSourceRoots(Module module2) {
        VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{ModuleRootManager.getInstance((Module)module2).getContentRoots(), ModuleRootManager.getInstance((Module)module2).getSourceRoots()};
        if (virtualFileArrayArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/FileIndexBase", "getModuleContentAndSourceRoots"));
        }
        return virtualFileArrayArray;
    }
}

