/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "module";
    @NonNls
    public static final String MODULE_NAME_ATTR = "module-name";
    @NonNls
    private static final String EXPORTED_ATTR = "exported";
    @NonNls
    private static final String PRODUCTION_ON_TEST_ATTRIBUTE = "production-on-test";
    private final ModulePointer myModulePointer;
    private boolean myExported;
    @NotNull
    private DependencyScope myScope;
    private boolean myProductionOnTestDependency;

    ModuleOrderEntryImpl(@NotNull Module module2, @NotNull RootModelImpl rootModel) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENTRY_TYPE, "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "<init>"));
        }
        super(rootModel);
        this.myExported = false;
        this.myModulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull String moduleName, @NotNull RootModelImpl rootModel) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "<init>"));
        }
        super(rootModel);
        this.myExported = false;
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(Element element, RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        this.myExported = false;
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        String moduleName = element.getAttributeValue(MODULE_NAME_ATTR);
        if (moduleName == null) {
            throw new InvalidDataException();
        }
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.readExternal((Element)element);
        this.myProductionOnTestDependency = element.getAttributeValue(PRODUCTION_ON_TEST_ATTRIBUTE) != null;
    }

    private ModuleOrderEntryImpl(ModuleOrderEntryImpl that, RootModelImpl rootModel) {
        super(rootModel);
        this.myExported = false;
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(that.myModulePointer.getModuleName());
        this.myExported = that.myExported;
        this.myProductionOnTestDependency = that.myProductionOnTestDependency;
        this.myScope = that.myScope;
    }

    @NotNull
    public Module getOwnerModule() {
        Module module2 = this.getRootModel().getModule();
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "getOwnerModule"));
        }
        return module2;
    }

    public boolean isProductionOnTestDependency() {
        return this.myProductionOnTestDependency;
    }

    public void setProductionOnTestDependency(boolean productionOnTestDependency) {
        this.myProductionOnTestDependency = productionOnTestDependency;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        OrderRootsEnumerator enumerator = this.getEnumerator(type);
        VirtualFile[] virtualFileArray = enumerator != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "getFiles"));
        }
        return virtualFileArray;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(OrderRootType type) {
        Module module2 = this.myModulePointer.getModule();
        if (module2 == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module2);
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        OrderRootsEnumerator enumerator = this.getEnumerator(rootType);
        String[] stringArray = enumerator != null ? enumerator.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "getUrls"));
        }
        return stringArray;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getModule() != null;
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        String string2 = this.getModuleName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "getPresentableName"));
        }
        return string2;
    }

    public boolean isSynthetic() {
        return false;
    }

    @Nullable
    public Module getModule() {
        return this.getRootModel().getConfigurationAccessor().getModule(this.myModulePointer.getModule(), this.myModulePointer.getModuleName());
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute(MODULE_NAME_ATTR, this.getModuleName());
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        if (this.myProductionOnTestDependency) {
            element.setAttribute(PRODUCTION_ON_TEST_ATTRIBUTE, "");
        }
        rootElement.addContent(element);
    }

    public String getModuleName() {
        return this.myModulePointer.getModuleName();
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleOrderEntryImpl(this, rootModel);
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value2) {
        this.getRootModel().assertWritable();
        this.myExported = value2;
    }

    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "getScope"));
        }
        return dependencyScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl", "setScope"));
        }
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }
}

