/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDetectionManagerImpl
extends LibraryDetectionManager {
    private final Map<List<VirtualFile>, List<Pair<LibraryKind, LibraryProperties>>> myCache = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean processProperties(@NotNull List<VirtualFile> files2, @NotNull LibraryDetectionManager.LibraryPropertiesProcessor processor2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/roots/impl/libraries/LibraryDetectionManagerImpl", "processProperties"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/libraries/LibraryDetectionManagerImpl", "processProperties"));
        }
        for (Pair<LibraryKind, LibraryProperties> pair : this.getOrComputeKinds(files2)) {
            if (processor2.processProperties((LibraryKind)pair.getFirst(), (LibraryProperties)pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Pair<LibraryType<?>, LibraryProperties<?>> detectType(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/roots/impl/libraries/LibraryDetectionManagerImpl", "detectType"));
        }
        Pair result2 = null;
        for (LibraryType type : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            Object properties = type.detect(files2);
            if (properties == null) continue;
            if (result2 != null) {
                return null;
            }
            result2 = Pair.create((Object)type, properties);
        }
        return result2;
    }

    private List<Pair<LibraryKind, LibraryProperties>> getOrComputeKinds(List<VirtualFile> files2) {
        List<Pair<LibraryKind, LibraryProperties>> result2 = this.myCache.get(files2);
        if (result2 == null) {
            result2 = LibraryDetectionManagerImpl.computeKinds(files2);
            this.myCache.put(files2, result2);
        }
        return result2;
    }

    private static List<Pair<LibraryKind, LibraryProperties>> computeKinds(List<VirtualFile> files2) {
        SmartList result2 = new SmartList();
        LibraryType[] libraryTypes = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        LibraryPresentationProvider[] presentationProviders = (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions();
        for (LibraryPresentationProvider provider : ContainerUtil.concat((Object[][])new LibraryPresentationProvider[][]{libraryTypes, presentationProviders})) {
            Object properties = provider.detect(files2);
            if (properties == null) continue;
            result2.add((Object)Pair.create((Object)provider.getKind(), properties));
        }
        return result2;
    }
}

