/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTypeServiceImpl
extends LibraryTypeService {
    private static final String DEFAULT_LIBRARY_NAME = "Unnamed";

    @Override
    public NewLibraryConfiguration createLibraryFromFiles(@NotNull LibraryRootsComponentDescriptor descriptor2, @NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, LibraryType<?> type, Project project2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl", "createLibraryFromFiles"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl", "createLibraryFromFiles"));
        }
        FileChooserDescriptor chooserDescriptor = descriptor2.createAttachFilesChooserDescriptor(null);
        chooserDescriptor.setTitle("Select Library Files");
        VirtualFile[] rootCandidates = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parentComponent, (Project)project2, (VirtualFile)contextDirectory);
        if (rootCandidates.length == 0) {
            return null;
        }
        List<OrderRoot> roots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, project2, descriptor2);
        if (roots.isEmpty()) {
            return null;
        }
        String name = LibraryTypeServiceImpl.suggestLibraryName(roots);
        return LibraryTypeServiceImpl.doCreate(type, name, roots);
    }

    private static <P extends LibraryProperties<?>> NewLibraryConfiguration doCreate(LibraryType<P> type, String name, final List<OrderRoot> roots) {
        return new NewLibraryConfiguration(name, type, type != null ? type.getKind().createDefaultProperties() : null){

            @Override
            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl$1", "addRoots"));
                }
                editor.addRoots(roots);
            }
        };
    }

    public static String suggestLibraryName(@NotNull VirtualFile[] classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl", "suggestLibraryName"));
        }
        if (classesRoots.length >= 1) {
            return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)classesRoots[0].getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }

    public static String suggestLibraryName(@NotNull List<OrderRoot> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl", "suggestLibraryName"));
        }
        if (roots.size() >= 1) {
            return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)roots.get(0).getFile().getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }
}

