/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JTree;

public class ToggleExcludedStateAction
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;

    public ToggleExcludedStateAction(JTree tree2, ContentEntryTreeEditor entryEditor) {
        super(tree2);
        this.myEntryTreeEditor = entryEditor;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(ProjectBundle.message((String)"module.toggle.excluded.action", (Object[])new Object[0]));
        templatePresentation.setDescription(ProjectBundle.message((String)"module.toggle.excluded.action.description", (Object[])new Object[0]));
        templatePresentation.setIcon(AllIcons.Modules.ExcludeRoot);
    }

    public boolean isSelected(AnActionEvent e2) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return false;
        }
        return this.myEntryTreeEditor.getContentEntryEditor().isExcludedOrUnderExcludedDirectory(selectedFiles[0]);
    }

    public void setSelected(AnActionEvent e2, boolean isSelected) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles.length != 0);
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        for (VirtualFile selectedFile : selectedFiles) {
            if (isSelected) {
                if (contentEntryEditor.isExcludedOrUnderExcludedDirectory(selectedFile)) continue;
                contentEntryEditor.addExcludeFolder(selectedFile);
                continue;
            }
            contentEntryEditor.removeExcludeFolder(selectedFile.getUrl());
        }
    }

    @Override
    public void update(AnActionEvent e2) {
        super.update(e2);
        Presentation presentation = e2.getPresentation();
        presentation.setText(ProjectBundle.message((String)"module.toggle.excluded.action", (Object[])new Object[0]));
    }
}

