/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.ui.Gray;
import com.intellij.util.ui.ImageUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public class ShadowBorderPainter {
    public static final ShadowPainter ourPopupShadowPainter = new ShadowPainter(AllIcons.Ide.Shadow.Popup.Top, AllIcons.Ide.Shadow.Popup.Top_right, AllIcons.Ide.Shadow.Popup.Right, AllIcons.Ide.Shadow.Popup.Bottom_right, AllIcons.Ide.Shadow.Popup.Bottom, AllIcons.Ide.Shadow.Popup.Bottom_left, AllIcons.Ide.Shadow.Popup.Left, AllIcons.Ide.Shadow.Popup.Top_left, Gray.x00.withAlpha(30));
    public static final ShadowPainter ourShadowPainter = new ShadowPainter(AllIcons.Ide.Shadow.Top, AllIcons.Ide.Shadow.Top_right, AllIcons.Ide.Shadow.Right, AllIcons.Ide.Shadow.Bottom_right, AllIcons.Ide.Shadow.Bottom, AllIcons.Ide.Shadow.Bottom_left, AllIcons.Ide.Shadow.Left, AllIcons.Ide.Shadow.Top_left, Gray.x00.withAlpha(30));

    private ShadowBorderPainter() {
    }

    public static BufferedImage createShadow(JComponent c2, int width, int height, boolean isPopup) {
        return ShadowBorderPainter.getPainter(isPopup).createShadow(c2, width, height);
    }

    private static ShadowPainter getPainter(boolean isPopup) {
        return isPopup ? ourPopupShadowPainter : ourShadowPainter;
    }

    public static BufferedImage createShadow(JComponent c2, int width, int height) {
        return ShadowBorderPainter.createShadow(c2, width, height, false);
    }

    public static BufferedImage createPopupShadow(JComponent c2, int width, int height) {
        return ShadowBorderPainter.createShadow(c2, width, height, true);
    }

    public static Shadow createShadow(Image source, int x2, int y2, boolean paintSource, int shadowSize) {
        source = ImageUtil.toBufferedImage((Image)source);
        float w2 = source.getWidth(null);
        float h2 = source.getHeight(null);
        float ratio = w2 / h2;
        float deltaX = shadowSize;
        float deltaY = (float)shadowSize / ratio;
        Image scaled = source.getScaledInstance((int)(w2 + deltaX), (int)(h2 + deltaY), 4);
        BufferedImage s2 = GraphicsUtilities.createCompatibleTranslucentImage((int)scaled.getWidth(null), (int)scaled.getHeight(null));
        Graphics2D graphics = (Graphics2D)s2.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(scaled, 0, 0, null);
        BufferedImage shadow = new ShadowRenderer(shadowSize, 0.25f, (Color)Gray.x00).createShadow(s2);
        if (paintSource) {
            Graphics imgG = shadow.getGraphics();
            double d2 = (double)shadowSize * 0.5;
            imgG.drawImage(source, (int)((double)shadowSize + d2), (int)((double)shadowSize + d2 / (double)ratio), null);
        }
        return new Shadow(shadow, x2 - shadowSize - 5, y2 - shadowSize + 2);
    }

    public static class Shadow {
        int x;
        int y;
        Image image;

        public Shadow(Image image, int x2, int y2) {
            this.x = x2;
            this.y = y2;
            this.image = image;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

