/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ShadowPainter {
    private final Icon myTop;
    private final Icon myTopRight;
    private final Icon myRight;
    private final Icon myBottomRight;
    private final Icon myBottom;
    private final Icon myBottomLeft;
    private final Icon myLeft;
    private final Icon myTopLeft;
    @Nullable
    private Color myBorderColor;

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft) {
        this.myTop = IconUtil.cropIcon((Icon)top, (int)1, (int)Integer.MAX_VALUE);
        this.myTopRight = topRight;
        this.myRight = IconUtil.cropIcon((Icon)right, (int)Integer.MAX_VALUE, (int)1);
        this.myBottomRight = bottomRight;
        this.myBottom = IconUtil.cropIcon((Icon)bottom, (int)1, (int)Integer.MAX_VALUE);
        this.myBottomLeft = bottomLeft;
        this.myLeft = IconUtil.cropIcon((Icon)left, (int)Integer.MAX_VALUE, (int)1);
        this.myTopLeft = topLeft;
    }

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft, @Nullable Color borderColor) {
        this(top, topRight, right, bottomRight, bottom, bottomLeft, left, topLeft);
        this.myBorderColor = borderColor;
    }

    public void setBorderColor(@Nullable Color borderColor) {
        this.myBorderColor = borderColor;
    }

    public BufferedImage createShadow(JComponent c2, int width, int height) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage(width, height, 3);
        Graphics2D g2 = image.createGraphics();
        this.paintShadow(c2, g2, 0, 0, width, height);
        g2.dispose();
        return image;
    }

    public void paintShadow(Component c2, Graphics2D g2, int x2, int y2, int width, int height) {
        int _y2;
        int _x2;
        int leftSize = this.myLeft.getIconWidth();
        int rightSize = this.myRight.getIconWidth();
        int bottomSize = this.myBottom.getIconHeight();
        int topSize = this.myTop.getIconHeight();
        this.myTopLeft.paintIcon(c2, g2, x2, y2);
        this.myTopRight.paintIcon(c2, g2, x2 + width - this.myTopRight.getIconWidth(), y2);
        this.myBottomRight.paintIcon(c2, g2, x2 + width - this.myBottomRight.getIconWidth(), y2 + height - this.myBottomRight.getIconHeight());
        this.myBottomLeft.paintIcon(c2, g2, x2, y2 + height - this.myBottomLeft.getIconHeight());
        for (_x2 = this.myTopLeft.getIconWidth(); _x2 < width - this.myTopRight.getIconWidth(); ++_x2) {
            this.myTop.paintIcon(c2, g2, _x2 + x2, y2);
        }
        for (_x2 = this.myBottomLeft.getIconWidth(); _x2 < width - this.myBottomLeft.getIconWidth(); ++_x2) {
            this.myBottom.paintIcon(c2, g2, _x2 + x2, y2 + height - bottomSize);
        }
        for (_y2 = this.myTopLeft.getIconHeight(); _y2 < height - this.myBottomLeft.getIconHeight(); ++_y2) {
            this.myLeft.paintIcon(c2, g2, x2, _y2 + y2);
        }
        for (_y2 = this.myTopRight.getIconHeight(); _y2 < height - this.myBottomRight.getIconHeight(); ++_y2) {
            this.myRight.paintIcon(c2, g2, x2 + width - rightSize, _y2 + y2);
        }
        if (this.myBorderColor != null) {
            g2.setColor(this.myBorderColor);
            g2.drawRect(x2 + leftSize - 1, y2 + topSize - 1, width - leftSize - rightSize + 1, height - topSize - bottomSize + 1);
        }
    }
}

