/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class AssertFocused
extends AbstractCommand {
    public static final String PREFIX = "%assert focused";

    public AssertFocused(String text2, int line) {
        super(text2, line);
    }

    @Override
    protected ActionCallback _execute(PlaybackContext context2) {
        ActionCallback result2 = new ActionCallback();
        String text2 = this.getText().substring(PREFIX.length()).trim();
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        if (text2.length() > 0) {
            String[] keyValue;
            for (String each : keyValue = text2.split(",")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    context2.error("Syntax error, must be comma-separated pairs key=value", this.getLine());
                    result2.setRejected();
                    return result2;
                }
                expected.put(eachPair[0], eachPair[1]);
            }
        }
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> {
            try {
                this.doAssert(expected, context2);
                result2.setDone();
            }
            catch (AssertionError error) {
                context2.error("Assertion failed: " + ((Throwable)((Object)error)).getMessage(), this.getLine());
                result2.setRejected();
            }
        });
        return result2;
    }

    private void doAssert(Map<String, String> expected, PlaybackContext context2) throws AssertionError {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            throw new AssertionError((Object)"No component focused");
        }
        LinkedHashMap actual = new LinkedHashMap();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String string2 : expected.keySet()) {
            testedKeys.add(string2);
            String actualValue = (String)actual.get(string2);
            String expectedValue = expected.get(string2);
            if (!expectedValue.equals(actualValue)) {
                throw new AssertionError((Object)(string2 + " expected: " + expectedValue + " but was: " + actualValue));
            }
        }
        HashMap untested = new HashMap();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, actual.get(eachKey));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String each : untested.keySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(each).append("=").append((String)untested.get(each));
        }
        context2.message("Untested info: " + stringBuffer.toString(), this.getLine());
    }
}

