/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class CallCommand
extends AbstractCommand {
    public static final String PREFIX = "%call";

    public CallCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    protected ActionCallback _execute(final PlaybackContext context2) {
        final ActionCallback cmdResult = new ActionCallback();
        String cmd = this.getText().substring(PREFIX.length()).trim();
        int open2 = cmd.indexOf("(");
        if (open2 == -1) {
            context2.error("( expected", this.getLine());
            return ActionCallback.DONE;
        }
        int close = cmd.lastIndexOf(")");
        if (close == -1) {
            context2.error(") expected", this.getLine());
            return ActionCallback.DONE;
        }
        String methodName = cmd.substring(0, open2);
        String[] args = cmd.substring(open2 + 1, close).split(",");
        boolean noArgs = args.length == 1 && args[0].length() == 0;
        Class[] types = noArgs ? new Class[1] : new Class[args.length + 1];
        types[0] = PlaybackContext.class;
        for (int i2 = 1; i2 < types.length; ++i2) {
            types[i2] = String.class;
        }
        try {
            Pair<Method, Class> methodClass = CallCommand.findMethod(context2, methodName, types);
            if (methodClass == null) {
                context2.error("No method \"" + methodName + "\" found in facade classes: " + context2.getCallClasses(), this.getLine());
                return ActionCallback.REJECTED;
            }
            Method m2 = (Method)methodClass.getFirst();
            if (!m2.getReturnType().isAssignableFrom(AsyncResult.class)) {
                context2.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object", this.getLine());
                return ActionCallback.REJECTED;
            }
            Object[] actualArgs = noArgs ? new Object[1] : new Object[args.length + 1];
            actualArgs[0] = context2;
            System.arraycopy(args, 0, actualArgs, 1, actualArgs.length - 1);
            AsyncResult result2 = (AsyncResult)m2.invoke(null, actualArgs);
            if (result2 == null) {
                context2.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object, but was null", this.getLine());
                return ActionCallback.REJECTED;
            }
            result2.doWhenDone((Consumer)new Consumer<String>(){

                public void consume(String s2) {
                    if (s2 != null) {
                        context2.message(s2, CallCommand.this.getLine());
                    }
                    cmdResult.setDone();
                }
            }).doWhenRejected(s2 -> {
                context2.error((String)s2, this.getLine());
                cmdResult.setRejected();
            });
        }
        catch (InvocationTargetException ignored) {
            context2.error("InvocationTargetException while executing command: " + cmd, this.getLine());
        }
        catch (IllegalAccessException ignored) {
            context2.error("IllegalAccessException while executing command: " + cmd, this.getLine());
        }
        return cmdResult;
    }

    private static Pair<Method, Class> findMethod(PlaybackContext context2, String methodName, Class[] types) {
        Set<Class> classes = context2.getCallClasses();
        for (Class eachClass : classes) {
            try {
                Method method2 = eachClass.getMethod(methodName, types);
                return Pair.create((Object)method2, (Object)eachClass);
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        return null;
    }
}

