/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import java.io.File;
import java.io.IOException;

public class CdCommand
extends AbstractCommand {
    public static final String PREFIX = "%cd";
    private String myDir;

    public CdCommand(String text2, int line) {
        super(text2, line);
        this.myDir = text2.substring(PREFIX.length()).trim();
    }

    @Override
    protected ActionCallback _execute(PlaybackContext context2) {
        File file2 = context2.getPathMacro().resolveFile(this.myDir, context2.getBaseDir());
        if (!file2.exists()) {
            context2.message("Cannot cd, directory doesn't exist: " + file2.getAbsoluteFile(), this.getLine());
            return ActionCallback.REJECTED;
        }
        try {
            context2.setBaseDir(file2.getCanonicalFile());
        }
        catch (IOException e2) {
            context2.setBaseDir(file2);
        }
        context2.message("{base.dir} set to " + context2.getBaseDir().getAbsolutePath(), this.getLine());
        return ActionCallback.DONE;
    }
}

