/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;

public class ProjectPlaybackCall {
    public static AsyncResult<String> openProjectClone(PlaybackContext context2, String path) {
        try {
            File parentDir = FileUtil.createTempDirectory((String)"funcTest", (String)"");
            File sourceDir = context2.getPathMacro().resolveFile(path, context2.getBaseDir());
            context2.message("Cloning project: " + sourceDir.getAbsolutePath(), context2.getCurrentLine());
            FileUtil.copyDir((File)sourceDir, (File)parentDir);
            File projectDir = new File(parentDir, sourceDir.getName());
            return ProjectPlaybackCall.openProject(context2, projectDir.getAbsolutePath());
        }
        catch (IOException e2) {
            return AsyncResult.rejected((String)"Cannot create temp directory for clone");
        }
    }

    public static AsyncResult<String> openLastProject(PlaybackContext context2) {
        return ProjectPlaybackCall.openProject(context2, RecentProjectsManager.getInstance().getLastProjectPath());
    }

    public static AsyncResult<String> openProject(PlaybackContext context2, String path) {
        final AsyncResult result2 = new AsyncResult();
        final ProjectManager pm = ProjectManager.getInstance();
        final Ref listener2 = new Ref();
        listener2.set((Object)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> {
                    pm.removeProjectManagerListener((ProjectManagerListener)listener2.get());
                    DumbService.getInstance((Project)project2).runWhenSmart(() -> result2.setDone((Object)("Opened successfully: " + project2.getPresentableUrl())));
                });
            }
        });
        pm.addProjectManagerListener((ProjectManagerListener)listener2.get());
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                pm.loadAndOpenProject(path);
            }
            catch (Exception e2) {
                context2.error(e2.getMessage(), context2.getCurrentLine());
                result2.setRejected();
            }
        });
        return result2;
    }
}

