/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class WindowSystemPlaybackCall {
    public static AsyncResult<String> printFocus(PlaybackContext context2) {
        AsyncResult result2 = new AsyncResult();
        WindowSystemPlaybackCall.getUiReady(context2).doWhenProcessed(() -> {
            LinkedHashMap<String, String> focusInfo = WindowSystemPlaybackCall.getFocusInfo();
            if (focusInfo == null) {
                result2.setRejected((Object)"No component focused");
                return;
            }
            StringBuffer text2 = new StringBuffer();
            Iterator<String> iterator2 = focusInfo.keySet().iterator();
            while (iterator2.hasNext()) {
                String key = iterator2.next();
                text2.append(key + "=" + focusInfo.get(key));
                if (!iterator2.hasNext()) continue;
                text2.append("|");
            }
            result2.setDone((Object)text2.toString());
        });
        return result2;
    }

    public static AsyncResult<String> waitForDialog(final PlaybackContext context2, final String title) {
        final AsyncResult result2 = new AsyncResult();
        final Ref listener2 = new Ref();
        listener2.set((Object)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Window wnd;
                if (event.getID() == 205 && (wnd = ((WindowEvent)event).getWindow()) instanceof JDialog && title.equals(((JDialog)wnd).getTitle())) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener((AWTEventListener)listener2.get());
                    SwingUtilities.invokeLater(() -> WindowSystemPlaybackCall.getUiReady(context2).notify((ActionCallback)result2));
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener((AWTEventListener)listener2.get(), 64L);
        SimpleTimer.getInstance().setUp(() -> {
            Toolkit.getDefaultToolkit().removeAWTEventListener((AWTEventListener)listener2.get());
            if (!result2.isProcessed()) {
                result2.setRejected((Object)("Timed out waiting for window: " + title));
            }
        }, (long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"));
        return result2;
    }

    public static AsyncResult<String> checkFocus(PlaybackContext context2, String expected) {
        AsyncResult result2 = new AsyncResult();
        LinkedHashMap<String, String> expectedMap = new LinkedHashMap<String, String>();
        if (expected.length() > 0) {
            String[] keyValue;
            for (String each : keyValue = expected.split("\\|")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    result2.setRejected((Object)"Syntax error, must be |-separated pairs key=value");
                    return result2;
                }
                expectedMap.put(eachPair[0], eachPair[1]);
            }
        }
        WindowSystemPlaybackCall.getUiReady(context2).doWhenDone(() -> {
            try {
                WindowSystemPlaybackCall.doAssert(expectedMap, (AsyncResult<String>)result2, context2);
            }
            catch (AssertionError error) {
                result2.setRejected((Object)("Assertion failed: " + ((Throwable)((Object)error)).getMessage()));
            }
        });
        return result2;
    }

    public static AsyncResult<String> waitForToolWindow(final PlaybackContext context2, final String id) {
        final AsyncResult result2 = new AsyncResult();
        WindowSystemPlaybackCall.findProject().doWhenDone((Consumer)new Consumer<Project>(){

            public void consume(Project project2) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(id);
                if (toolWindow == null) {
                    result2.setRejected((Object)("Cannot find tool window with id: " + id));
                    return;
                }
                toolWindow.getReady((Object)context2).doWhenDone(result2.createSetDoneRunnable()).doWhenRejected(() -> result2.setRejected((Object)("Cannot activate tool window with id:" + id)));
            }
        }).doWhenRejected(() -> result2.setRejected((Object)"Cannot retrieve open project"));
        return result2;
    }

    public static AsyncResult<Project> findProject() {
        AsyncResult project2 = new AsyncResult();
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(() -> {
            IdeFrame frame;
            Component parent = UIUtil.findUltimateParent((Component)fm.getFocusOwner());
            if (parent instanceof IdeFrame && (frame = (IdeFrame)parent).getProject() != null) {
                project2.setDone((Object)frame.getProject());
                return;
            }
            project2.setRejected();
        });
        return project2;
    }

    public static AsyncResult<String> contextMenu(PlaybackContext context2, String path) {
        AsyncResult result2 = new AsyncResult();
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(() -> {
            Component owner = fm.getFocusOwner();
            if (owner == null) {
                result2.setRejected((Object)"No component focused");
                return;
            }
            ActionManager am = ActionManager.getInstance();
            AnAction showPopupMenu = am.getAction("ShowPopupMenu");
            if (showPopupMenu == null) {
                result2.setRejected((Object)"Cannot find action: ShowPopupMenu");
                return;
            }
            am.tryToExecute(showPopupMenu, (InputEvent)new MouseEvent(owner, 501, System.currentTimeMillis(), 0, 0, 0, 1, true), null, null, false).doWhenDone(() -> SwingUtilities.invokeLater(() -> {
                MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                if (selectedPath.length == 0) {
                    result2.setRejected((Object)"Failed to find active popup menu");
                    return;
                }
                WindowSystemPlaybackCall.selectNext(context2, path.split("\\|"), 0, selectedPath[0].getSubElements(), (AsyncResult<String>)result2);
            })).doWhenRejected(() -> result2.setRejected((Object)"Cannot invoke popup menu from the ShowPopupMenu action, action call rejected"));
        });
        return result2;
    }

    private static void selectNext(final PlaybackContext context2, final String[] toSelect, final int toSelectIndex, MenuElement[] menuElements, final AsyncResult<String> result2) {
        if (menuElements == null || menuElements.length == 0) {
            result2.setDone();
        }
        if (toSelectIndex > toSelect.length - 1) {
            result2.setDone();
            return;
        }
        String target = toSelect[toSelectIndex];
        for (MenuElement each : menuElements) {
            if (each.getComponent() instanceof AbstractButton) {
                AbstractButton eachButton = (AbstractButton)each.getComponent();
                if (eachButton.getText() == null || !eachButton.getText().startsWith(target)) continue;
                WindowSystemPlaybackCall.activateItem(context2, each).doWhenDone((Consumer)new Consumer<MenuElement[]>(){

                    public void consume(MenuElement[] menuElements) {
                        WindowSystemPlaybackCall.selectNext(context2, toSelect, toSelectIndex + 1, menuElements, (AsyncResult<String>)result2);
                    }
                }).doWhenRejected(() -> result2.setRejected((Object)("Cannot activate menu element: " + eachButton.getText())));
                return;
            }
            result2.setRejected((Object)("Unknown class for context menu item: " + each.getComponent()));
            return;
        }
        result2.setRejected((Object)("Failed to find menu item: " + target));
    }

    private static AsyncResult<MenuElement[]> activateItem(PlaybackContext context2, MenuElement element) {
        AsyncResult result2 = new AsyncResult();
        AbstractButton c2 = (AbstractButton)element.getComponent();
        Runnable pressRunnable = () -> {
            Robot robot = context2.getRobot();
            Point location = c2.getLocationOnScreen();
            Dimension size = c2.getSize();
            Point point = new Point(location.x + size.width / 2, location.y + size.height / 2);
            robot.mouseMove(point.x, point.y);
            robot.delay(90);
            robot.mousePress(16);
            robot.delay(90);
            robot.mouseRelease(16);
            robot.delay(90);
            context2.flushAwtAndRunInEdt(() -> context2.flushAwtAndRunInEdt(() -> {
                MenuElement[] subElements = element.getSubElements();
                if (subElements == null || subElements.length == 0) {
                    result2.setDone();
                } else {
                    MenuElement[] menuElements = subElements[0].getSubElements();
                    result2.setDone((Object)menuElements);
                }
            }));
        };
        if (c2.isShowing()) {
            context2.runPooledThread(pressRunnable);
        } else {
            context2.delayAndRunInEdt(() -> {
                if (c2.isShowing()) {
                    context2.runPooledThread(pressRunnable);
                } else {
                    result2.setRejected();
                }
            }, 1000L);
        }
        return result2;
    }

    public static ActionCallback getUiReady(PlaybackContext context2) {
        ActionCallback result2 = new ActionCallback();
        context2.flushAwtAndRunInEdt(() -> UiActivityMonitor.getInstance().getBusy(new UiActivity[0]).getReady((Object)context2).notify(result2));
        return result2;
    }

    private static void doAssert(Map<String, String> expected, AsyncResult<String> result2, PlaybackContext context2) throws AssertionError {
        LinkedHashMap<String, String> actual = WindowSystemPlaybackCall.getFocusInfo();
        if (actual == null) {
            result2.setRejected((Object)"No component focused");
            return;
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String string2 : expected.keySet()) {
            testedKeys.add(string2);
            String actualValue = actual.get(string2);
            String expectedValue = expected.get(string2);
            if (expectedValue.equals(actualValue)) continue;
            result2.setRejected((Object)(string2 + " expected: " + expectedValue + " but was: " + actualValue));
            return;
        }
        HashMap<String, String> untested = new HashMap<String, String>();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, actual.get(eachKey));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String each : untested.keySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(each).append("=").append((String)untested.get(each));
        }
        result2.setDone();
        if (stringBuffer.length() > 0) {
            context2.message("Untested focus info: " + stringBuffer.toString(), context2.getCurrentLine());
        }
    }

    private static LinkedHashMap<String, String> getFocusInfo() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        LinkedHashMap<String, String> actual = new LinkedHashMap<String, String>();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        return actual;
    }

    public static AsyncResult<String> flushUi(PlaybackContext context2) {
        AsyncResult result2 = new AsyncResult();
        WindowSystemPlaybackCall.getUiReady(context2).notify((ActionCallback)result2);
        return result2;
    }
}

