/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUpdateDialog
extends DialogWrapper {
    private final boolean myEnableLink;

    protected AbstractUpdateDialog(boolean enableLink) {
        super(true);
        this.myEnableLink = enableLink;
        this.setTitle(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    protected void init() {
        this.setOKButtonText(this.getOkButtonText());
        this.setCancelButtonText(this.getCancelButtonText());
        super.init();
    }

    protected String getOkButtonText() {
        return CommonBundle.getOkButtonText();
    }

    protected String getCancelButtonText() {
        return CommonBundle.getCancelButtonText();
    }

    protected void configureMessageArea(@NotNull JEditorPane area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/openapi/updateSettings/impl/AbstractUpdateDialog", "configureMessageArea"));
        }
        String messageBody = this.myEnableLink ? IdeBundle.message((String)"updates.configure.label", (Object[])new Object[]{ShowSettingsUtil.getSettingsMenuName()}) : "";
        this.configureMessageArea(area, messageBody, null, null);
    }

    protected void configureMessageArea(@NotNull JEditorPane area, @NotNull String messageBody, @Nullable Color fontColor, @Nullable HyperlinkListener listener2) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/openapi/updateSettings/impl/AbstractUpdateDialog", "configureMessageArea"));
        }
        if (messageBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBody", "com/intellij/openapi/updateSettings/impl/AbstractUpdateDialog", "configureMessageArea"));
        }
        String text2 = "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)fontColor, null, null) + "<style>body {background: #" + ColorUtil.toHex((Color)UIUtil.getPanelBackground()) + ";}</style></head><body>" + messageBody + "</body></html>";
        area.setBackground(UIUtil.getPanelBackground());
        area.setBorder(IdeBorderFactory.createEmptyBorder());
        area.setText(text2);
        area.setCaretPosition(0);
        area.setEditable(false);
        if (listener2 == null && this.myEnableLink) {
            listener2 = e2 -> {
                if (area == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/openapi/updateSettings/impl/AbstractUpdateDialog", "lambda$configureMessageArea$0"));
                }
                if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)area, (Configurable)new UpdateSettingsConfigurable(false));
                }
            };
        }
        if (listener2 != null) {
            area.addHyperlinkListener(listener2);
        }
    }
}

