/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.util.BuildNumber;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckForUpdateResult {
    private final UpdateStrategy.State myState;
    private final BuildInfo myNewBuild;
    private final UpdateChannel myUpdatedChannel;
    private final Exception myError;

    public CheckForUpdateResult(@Nullable BuildInfo newBuild, @Nullable UpdateChannel updatedChannel) {
        this.myState = UpdateStrategy.State.LOADED;
        this.myNewBuild = newBuild;
        this.myUpdatedChannel = updatedChannel;
        this.myError = null;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state, @Nullable Exception e2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this.myState = state;
        this.myNewBuild = null;
        this.myUpdatedChannel = null;
        this.myError = e2;
    }

    @NotNull
    public UpdateStrategy.State getState() {
        UpdateStrategy.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "getState"));
        }
        return state;
    }

    @Nullable
    public BuildInfo getNewBuild() {
        return this.myNewBuild;
    }

    @Nullable
    public PatchInfo findPatchForBuild(@NotNull BuildNumber build2) {
        if (build2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "build", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "findPatchForBuild"));
        }
        List patches = this.myNewBuild != null ? this.myNewBuild.getPatches() : Collections.emptyList();
        return patches.stream().filter(p2 -> {
            if (build2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "build", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "lambda$findPatchForBuild$0"));
            }
            return p2.isAvailable() && p2.getFromBuild().compareTo(build2) == 0;
        }).findFirst().orElse(null);
    }

    @Nullable
    public UpdateChannel getUpdatedChannel() {
        return this.myUpdatedChannel;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }
}

