/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance(UpdateCheckerComponent.class);
    private static final long CHECK_INTERVAL = 86400000L;
    private final Alarm myCheckForUpdatesAlarm;
    private final Runnable myCheckRunnable;
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(@NotNull Application app, @NotNull UpdateSettings settings) {
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        this.myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myCheckRunnable = () -> UpdateChecker.updateAndShowResult().doWhenDone(() -> this.queueNextCheck(86400000L));
        Disposer.register((Disposable)this, (Disposable)this.myCheckForUpdatesAlarm);
        this.mySettings = settings;
        this.updateDefaultChannel();
        this.checkSecureConnection(app);
        this.scheduleOnStartCheck(app);
        UpdateCheckerComponent.cleanupPatch();
    }

    private void updateDefaultChannel() {
        ChannelStatus current = this.mySettings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isEAP();
        if (eap && current != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                String message2 = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.NOTIFICATIONS.createNotification(title, message2, NotificationType.INFORMATION, null).notify(null);
            }
        }
        if (!eap && current == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void checkSecureConnection(final Application app) {
        if (this.mySettings.isSecureConnection() && !this.mySettings.canUseSecureConnection()) {
            this.mySettings.setSecureConnection(false);
            String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            String message2 = IdeBundle.message((String)"update.sni.disabled.message", (Object[])new Object[0]);
            UpdateChecker.NOTIFICATIONS.createNotification(title, message2, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e2) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$1", "hyperlinkActivated"));
                    }
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$1", "hyperlinkActivated"));
                    }
                    notification.expire();
                    app.invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(null, UpdateSettingsConfigurable.class), ModalityState.NON_MODAL);
                }
            }).notify(null);
        }
    }

    private void scheduleOnStartCheck(Application app) {
        if (!this.mySettings.isCheckNeeded()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2", "appFrameCreated"));
                }
                BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
                BuildNumber lastBuildChecked = BuildNumber.fromString((String)UpdateCheckerComponent.this.mySettings.getLasBuildChecked());
                long timeSinceLastCheck = Math.max(System.currentTimeMillis() - UpdateCheckerComponent.this.mySettings.getLastTimeChecked(), 0L);
                if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= 86400000L) {
                    UpdateCheckerComponent.this.myCheckRunnable.run();
                } else {
                    UpdateCheckerComponent.this.queueNextCheck(86400000L - timeSinceLastCheck);
                }
            }
        });
    }

    private static void cleanupPatch() {
        new Task.Backgroundable(null, IdeBundle.message((String)"update.cleaning.patch.progress", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$3", "run"));
                }
                UpdateInstaller.cleanupPatch();
            }
        }.queue();
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    public void initComponent() {
        PluginsAdvertiser.ensureDeleted();
    }

    public void dispose() {
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }
}

