/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.util.Comparator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB/\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB9\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy;", "", "majorVersion", "", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "updatesInfo", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "updateSettings", "Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;", "(ILcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;)V", "customization", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "(ILcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;)V", "updates", "settings", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;)V", "lineage", "checkForUpdates", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "compareBuilds", "n1", "n2", "isApplicable", "", "candidate", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "ignoredBuilds", "", "", "State", "platform-impl"})
public final class UpdateStrategy {
    private final int lineage;
    private final BuildNumber currentBuild;
    private final UpdatesInfo updates;
    private final UserUpdateSettings settings;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckForUpdateResult checkForUpdates() {
        Pair result2;
        void $receiver$iv;
        String string2 = this.currentBuild.getProductCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"currentBuild.productCode");
        Product product = this.updates.get(string2);
        if (product == null || product.getChannels().isEmpty()) {
            return new CheckForUpdateResult(State.NOTHING_LOADED, null);
        }
        ChannelStatus selectedChannel = this.settings.getSelectedChannelStatus();
        Set ignoredBuilds = CollectionsKt.toSet((Iterable)this.settings.getIgnoredBuildNumbers());
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)product.getChannels()), (Function1)((Function1)new Function1<UpdateChannel, Boolean>(selectedChannel){
            final /* synthetic */ ChannelStatus $selectedChannel;

            public final boolean invoke(@NotNull UpdateChannel ch) {
                Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
                return ch.getStatus().compareTo((Enum)this.$selectedChannel) >= 0;
            }
            {
                this.$selectedChannel = channelStatus;
                super(1);
            }
        }));
        void var6_5 = $receiver$iv;
        Comparator comparator2 = new Comparator<UpdateChannel>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b2) {
                UpdateChannel ch = (UpdateChannel)a;
                Comparable comparable = (Comparable)((Object)ch.getStatus());
                ch = (UpdateChannel)b2;
                Comparable comparable2 = comparable;
                ChannelStatus channelStatus = ch.getStatus();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)channelStatus)));
            }
        };
        Pair pair = result2 = (Pair)SequencesKt.maxWith((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)var6_5, (Comparator)comparator2), (Function1)checkForUpdates.result.3.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends BuildInfo, ? extends UpdateChannel>, Boolean>(this, ignoredBuilds){
            final /* synthetic */ UpdateStrategy this$0;
            final /* synthetic */ Set $ignoredBuilds;

            public final boolean invoke(@NotNull Pair<BuildInfo, UpdateChannel> p2) {
                Intrinsics.checkParameterIsNotNull(p2, (String)"p");
                return UpdateStrategy.access$isApplicable(this.this$0, (BuildInfo)p2.getFirst(), this.$ignoredBuilds);
            }
            {
                this.this$0 = updateStrategy;
                this.$ignoredBuilds = set2;
                super(1);
            }
        })), (Comparator)new Comparator<Pair<? extends BuildInfo, ? extends UpdateChannel>>(this){
            final /* synthetic */ UpdateStrategy this$0;

            public final int compare(Pair<BuildInfo, UpdateChannel> p1, Pair<BuildInfo, UpdateChannel> p2) {
                return UpdateStrategy.access$compareBuilds(this.this$0, ((BuildInfo)p1.getFirst()).getNumber(), ((BuildInfo)p2.getFirst()).getNumber());
            }
            {
                this.this$0 = updateStrategy;
            }
        });
        Pair pair2 = result2;
        return new CheckForUpdateResult(pair != null ? (BuildInfo)pair.getFirst() : null, pair2 != null ? (UpdateChannel)pair2.getSecond() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(BuildInfo candidate, Set<String> ignoredBuilds) {
        if (candidate.getNumber().compareTo(this.currentBuild) <= 0) return false;
        if (!(ignoredBuilds.contains(candidate.getNumber().asStringWithoutProductCode()) ^ true)) return false;
        BuildRange buildRange = candidate.getTarget();
        if (buildRange == null) return true;
        boolean bl = buildRange.inRange(this.currentBuild);
        if (!bl) return false;
        return true;
    }

    private final int compareBuilds(BuildNumber n1, BuildNumber n2) {
        return n1.getBaselineVersion() == this.lineage && n2.getBaselineVersion() != this.lineage ? 1 : (n2.getBaselineVersion() == this.lineage && n1.getBaselineVersion() != this.lineage ? -1 : n1.compareTo(n2));
    }

    public UpdateStrategy(@NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updates, @NotNull UserUpdateSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updates, (String)"updates");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.currentBuild = currentBuild;
        this.updates = updates;
        this.settings = settings;
        this.lineage = this.currentBuild.getBaselineVersion();
    }

    @Deprecated(message="use {@link #UpdateStrategy(BuildNumber, UpdatesInfo, UserUpdateSettings)}")
    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updatesInfo, (String)"updatesInfo");
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        this(currentBuild, updatesInfo, updateSettings);
    }

    @Deprecated(message="use {@link #UpdateStrategy(BuildNumber, UpdatesInfo, UserUpdateSettings)}")
    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings, @NotNull UpdateStrategyCustomization customization) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updatesInfo, (String)"updatesInfo");
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        Intrinsics.checkParameterIsNotNull((Object)customization, (String)"customization");
        this(currentBuild, updatesInfo, updateSettings);
    }

    public static final /* synthetic */ boolean access$isApplicable(UpdateStrategy $this, @NotNull BuildInfo candidate, @NotNull Set ignoredBuilds) {
        return $this.isApplicable(candidate, ignoredBuilds);
    }

    public static final /* synthetic */ int access$compareBuilds(UpdateStrategy $this, @NotNull BuildNumber n1, @NotNull BuildNumber n2) {
        return $this.compareBuilds(n1, n2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy$State;", "", "(Ljava/lang/String;I)V", "LOADED", "CONNECTION_ERROR", "NOTHING_LOADED", "platform-impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State LOADED;
        public static final /* enum */ State CONNECTION_ERROR;
        public static final /* enum */ State NOTHING_LOADED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = LOADED = new State();
            stateArray[1] = CONNECTION_ERROR = new State();
            stateArray[2] = NOTHING_LOADED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }
    }
}

