/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginAdvertiserEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.type.associations.detected");
    private final Project myProject;
    private final EditorNotifications myNotifications;
    private final Set<String> myEnabledExtensions = new HashSet<String>();

    public PluginAdvertiserEditorNotificationProvider(Project project2, EditorNotifications notifications) {
        this.myProject = project2;
        this.myNotifications = notifications;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider", "createNotificationPanel"));
        }
        if (file2.getFileType() != PlainTextFileType.INSTANCE && !(file2.getFileType() instanceof AbstractFileType)) {
            return null;
        }
        String extension = file2.getExtension();
        String fileName = file2.getName();
        if (extension != null && this.isIgnored("*." + extension) || this.isIgnored(fileName)) {
            return null;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions != null) {
            EditorNotificationPanel panel2;
            EditorNotificationPanel editorNotificationPanel = panel2 = extension != null ? this.createPanel("*." + extension, knownExtensions) : null;
            if (panel2 != null) {
                return panel2;
            }
            return this.createPanel(fileName, knownExtensions);
        }
        return null;
    }

    private boolean isIgnored(String extension) {
        return this.myEnabledExtensions.contains(extension) || UnknownFeaturesCollector.getInstance(this.myProject).isIgnored(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
    }

    private EditorNotificationPanel createPanel(String extension, PluginsAdvertiser.KnownExtensions knownExtensions) {
        Set<PluginsAdvertiser.Plugin> plugins2 = knownExtensions.find(extension);
        if (plugins2 != null && !plugins2.isEmpty()) {
            return this.createPanel(extension, plugins2);
        }
        return null;
    }

    @Nullable
    private EditorNotificationPanel createPanel(String extension, Set<PluginsAdvertiser.Plugin> plugins2) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText("Plugins supporting " + extension + " files found.");
        IdeaPluginDescriptor disabledPlugin = PluginsAdvertiser.getDisabledPlugin(plugins2);
        if (disabledPlugin != null) {
            panel2.createActionLabel("Enable " + disabledPlugin.getName() + " plugin", () -> {
                this.myEnabledExtensions.add(extension);
                this.myNotifications.updateAllNotifications();
                PluginsAdvertiser.enablePlugins(this.myProject, Collections.singletonList(disabledPlugin));
            });
        } else if (PluginAdvertiserEditorNotificationProvider.hasNonBundledPlugin(plugins2)) {
            panel2.createActionLabel("Install plugins", () -> {
                HashSet<String> pluginIds = new HashSet<String>();
                for (PluginsAdvertiser.Plugin plugin : plugins2) {
                    pluginIds.add(plugin.myPluginId);
                }
                PluginsAdvertiser.installAndEnablePlugins(pluginIds, () -> {
                    this.myEnabledExtensions.add(extension);
                    this.myNotifications.updateAllNotifications();
                });
            });
        } else if (PluginsAdvertiser.hasBundledPluginToInstall(plugins2) != null) {
            if (PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                return null;
            }
            panel2.setText(extension + " files are supported by " + "IntelliJ IDEA Ultimate Edition");
            panel2.createActionLabel("Check IntelliJ IDEA Ultimate Edition", () -> {
                this.myEnabledExtensions.add(extension);
                PluginsAdvertiser.openDownloadPage();
            });
            panel2.createActionLabel("Do not suggest Ultimate Edition", () -> {
                PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                this.myNotifications.updateAllNotifications();
            });
        } else {
            return null;
        }
        panel2.createActionLabel("Ignore extension", () -> {
            UnknownFeaturesCollector.getInstance(this.myProject).ignoreFeature(PluginAdvertiserEditorNotificationProvider.createExtensionFeature(extension));
            this.myNotifications.updateAllNotifications();
        });
        return panel2;
    }

    private static boolean hasNonBundledPlugin(Set<PluginsAdvertiser.Plugin> plugins2) {
        for (PluginsAdvertiser.Plugin plugin : plugins2) {
            if (plugin.myBundled) continue;
            return true;
        }
        return false;
    }

    private static UnknownFeature createExtensionFeature(String extension) {
        return new UnknownFeature(FileTypeFactory.FILE_TYPE_FACTORY_EP.getName(), "File Type", extension);
    }
}

