/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsAdvertiser
implements StartupActivity {
    @NonNls
    public static final String IGNORE_ULTIMATE_EDITION = "ignoreUltimateEdition";
    private static final Logger LOG = Logger.getInstance((String)("#" + PluginsAdvertiser.class.getName()));
    private static final String FEATURE_IMPLEMENTATIONS_URL = "https://plugins.jetbrains.com/feature/getImplementations?";
    private static final String CASHED_EXTENSIONS = "extensions.xml";
    public static final String IDEA_ULTIMATE_EDITION = "IntelliJ IDEA Ultimate Edition";
    public static final String ULTIMATE_EDITION_SUGGESTION = "Do not suggest Ultimate Edition";
    public static final String CHECK_ULTIMATE_EDITION_TITLE = "Check IntelliJ IDEA Ultimate Edition";
    public static final String DISPLAY_ID = "Plugins Suggestion";
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugins Suggestion", NotificationDisplayType.STICKY_BALLOON, true);
    private static SoftReference<KnownExtensions> ourKnownExtensions = new SoftReference(null);

    public static List<Plugin> retrieve(UnknownFeature unknownFeature) {
        String featureType = unknownFeature.getFeatureType();
        String implementationName = unknownFeature.getImplementationName();
        String buildNumber = ApplicationInfo.getInstance().getApiVersion();
        String pluginRepositoryUrl = "https://plugins.jetbrains.com/feature/getImplementations?featureType=" + featureType + "&implementationName=" + implementationName.replaceAll("#", "%23") + "&build=" + buildNumber;
        return (List)HttpRequests.request((String)pluginRepositoryUrl).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<Plugin>>(){

            public List<Plugin> process(@NotNull HttpRequests.Request request2) throws IOException {
                if (request2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$1", "process"));
                }
                JsonReader jsonReader = new JsonReader((Reader)request2.getReader());
                jsonReader.setLenient(true);
                JsonElement jsonRootElement = new JsonParser().parse(jsonReader);
                ArrayList<Plugin> result2 = new ArrayList<Plugin>();
                for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    JsonElement pluginId = jsonObject.get("pluginId");
                    JsonElement pluginName = jsonObject.get("pluginName");
                    JsonElement bundled = jsonObject.get("bundled");
                    result2.add(new Plugin(PluginId.getId((String)StringUtil.unquoteString((String)pluginId.toString())), pluginName != null ? StringUtil.unquoteString((String)pluginName.toString()) : null, Boolean.parseBoolean(StringUtil.unquoteString((String)bundled.toString()))));
                }
                return result2;
            }
        }, null, LOG);
    }

    private static Map<String, Set<Plugin>> loadSupportedExtensions(@NotNull List<IdeaPluginDescriptor> allPlugins) {
        if (allPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPlugins", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser", "loadSupportedExtensions"));
        }
        final HashMap<String, IdeaPluginDescriptor> availableIds = new HashMap<String, IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor plugin : allPlugins) {
            availableIds.put(plugin.getPluginId().getIdString(), plugin);
        }
        String pluginRepositoryUrl = "https://plugins.jetbrains.com/feature/getImplementations?featureType=" + FileTypeFactory.FILE_TYPE_FACTORY_EP.getName();
        return (Map)HttpRequests.request((String)pluginRepositoryUrl).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Map<String, Set<Plugin>>>(){

            public Map<String, Set<Plugin>> process(@NotNull HttpRequests.Request request2) throws IOException {
                if (request2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$2", "process"));
                }
                JsonReader jsonReader = new JsonReader((Reader)request2.getReader());
                jsonReader.setLenient(true);
                JsonElement jsonRootElement = new JsonParser().parse(jsonReader);
                HashMap<String, Set<Plugin>> result2 = new HashMap<String, Set<Plugin>>();
                for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                    IdeaPluginDescriptor loadedPlugin;
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String pluginId = StringUtil.unquoteString((String)jsonObject.get("pluginId").toString());
                    JsonElement bundledExt = jsonObject.get("bundled");
                    boolean isBundled = Boolean.parseBoolean(bundledExt.toString());
                    IdeaPluginDescriptor fromServerPluginDescription = (IdeaPluginDescriptor)availableIds.get(pluginId);
                    if (fromServerPluginDescription == null && !isBundled || (loadedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId))) != null && loadedPlugin.isEnabled() || loadedPlugin != null && fromServerPluginDescription != null && StringUtil.compareVersionNumbers((String)loadedPlugin.getVersion(), (String)fromServerPluginDescription.getVersion()) >= 0 || fromServerPluginDescription != null && PluginManagerCore.isBrokenPlugin(fromServerPluginDescription)) continue;
                    JsonElement ext = jsonObject.get("implementationName");
                    String extension = StringUtil.unquoteString((String)ext.toString());
                    HashSet<Plugin> pluginIds = (HashSet<Plugin>)result2.get(extension);
                    if (pluginIds == null) {
                        pluginIds = new HashSet<Plugin>();
                        result2.put(extension, pluginIds);
                    }
                    JsonElement pluginNameElement = jsonObject.get("pluginName");
                    pluginIds.add(new Plugin(PluginId.getId((String)pluginId), pluginNameElement != null ? StringUtil.unquoteString((String)pluginNameElement.toString()) : null, isBundled));
                }
                PluginsAdvertiser.saveExtensions(result2);
                return result2;
            }
        }, null, LOG);
    }

    public static void ensureDeleted() {
        FileUtil.delete((File)PluginsAdvertiser.getExtensionsFile());
    }

    public static KnownExtensions loadExtensions() {
        KnownExtensions knownExtensions = (KnownExtensions)ourKnownExtensions.get();
        if (knownExtensions != null) {
            return knownExtensions;
        }
        try {
            File file2 = PluginsAdvertiser.getExtensionsFile();
            if (file2.isFile()) {
                knownExtensions = (KnownExtensions)XmlSerializer.deserialize((Element)JDOMUtil.load((File)file2), KnownExtensions.class);
                ourKnownExtensions = new SoftReference((Object)knownExtensions);
                return knownExtensions;
            }
        }
        catch (Exception e2) {
            LOG.info((Throwable)e2);
        }
        return null;
    }

    private static File getExtensionsFile() {
        return new File(PathManager.getPluginsPath(), CASHED_EXTENSIONS);
    }

    private static void saveExtensions(Map<String, Set<Plugin>> extensions) throws IOException {
        File plugins2 = PluginsAdvertiser.getExtensionsFile();
        if (!plugins2.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins2);
        }
        JDOMUtil.write((Parent)XmlSerializer.serialize((Object)new KnownExtensions(extensions)), (File)plugins2);
    }

    public static void openDownloadPage() {
        BrowserUtil.browse((String)ApplicationInfo.getInstance().getCompanyURL());
    }

    static void enablePlugins(Project project2, Collection<IdeaPluginDescriptor> disabledPlugins) {
        PluginManagerConfigurable managerConfigurable = new PluginManagerConfigurable(PluginManagerUISettings.getInstance());
        PluginManagerMain createPanel2 = managerConfigurable.getOrCreatePanel();
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)managerConfigurable, () -> {
            InstalledPluginsTableModel pluginsModel = (InstalledPluginsTableModel)createPanel2.getPluginsModel();
            IdeaPluginDescriptor[] descriptors = disabledPlugins.toArray(new IdeaPluginDescriptor[disabledPlugins.size()]);
            pluginsModel.enableRows(descriptors, Boolean.TRUE);
            createPanel2.getPluginTable().select(descriptors);
        });
    }

    @Nullable
    static IdeaPluginDescriptor getDisabledPlugin(Set<Plugin> plugins2) {
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        for (Plugin plugin : plugins2) {
            if (!disabledPlugins.contains(plugin.myPluginId)) continue;
            return PluginManager.getPlugin(PluginId.getId((String)plugin.myPluginId));
        }
        return null;
    }

    static List<String> hasBundledPluginToInstall(Collection<Plugin> plugins2) {
        if (PlatformUtils.isIdeaUltimate()) {
            return null;
        }
        ArrayList<String> bundled = new ArrayList<String>();
        for (Plugin plugin : plugins2) {
            if (!plugin.myBundled || PluginManager.getPlugin(PluginId.getId((String)plugin.myPluginId)) != null) continue;
            bundled.add(plugin.myPluginName != null ? plugin.myPluginName : plugin.myPluginId);
        }
        return bundled.isEmpty() ? null : bundled;
    }

    public static void installAndEnablePlugins(final @NotNull Set<String> pluginIds, final @NotNull Runnable onSuccess) {
        if (pluginIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginIds", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser", "installAndEnablePlugins"));
        }
        if (onSuccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSuccess", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser", "installAndEnablePlugins"));
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(null, "Search for Plugins in Repository", true){
            private final Set<PluginDownloader> myPlugins;
            private List<IdeaPluginDescriptor> myAllPlugins;
            {
                super(arg0, arg1, arg2);
                this.myPlugins = new HashSet<PluginDownloader>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$3", "run"));
                }
                try {
                    this.myAllPlugins = RepositoryHelper.loadPluginsFromAllRepositories(indicator);
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        if (descriptor2.isEnabled() || !pluginIds.contains(descriptor2.getPluginId().getIdString())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(descriptor2));
                    }
                    for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                        if (!pluginIds.contains(loadedPlugin.getPluginId().getIdString())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                }
                catch (Exception e2) {
                    LOG.info((Throwable)e2);
                }
            }

            public void onSuccess() {
                PluginsAdvertiserDialog advertiserDialog;
                if (this.myAllPlugins != null && (advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[this.myPlugins.size()]), PluginManagerMain.mapToPluginIds(this.myAllPlugins))).showAndGet()) {
                    onSuccess.run();
                }
            }
        });
    }

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser", "runActivity"));
        }
        if (!UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        UnknownFeaturesCollector collectorSuggester = UnknownFeaturesCollector.getInstance(project2);
        final Set<UnknownFeature> unknownFeatures = collectorSuggester.getUnknownFeatures();
        final KnownExtensions extensions = PluginsAdvertiser.loadExtensions();
        if (extensions != null && unknownFeatures.isEmpty()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser", "lambda$runActivity$1"));
            }
            application.executeOnPooledThread(new Runnable(){
                private final Set myPlugins = new HashSet();
                private List myAllPlugins;
                private final Map myDisabledPlugins = new HashMap();
                private List myBundledPlugin;
                private final MultiMap myFeatures = new MultiMap();

                @Override
                public void run() {
                    if (project2.isDisposed()) {
                        return;
                    }
                    try {
                        this.myAllPlugins = RepositoryHelper.loadPluginsFromAllRepositories(null);
                        if (project2.isDisposed()) {
                            return;
                        }
                        if (extensions == null) {
                            PluginsAdvertiser.loadSupportedExtensions(this.myAllPlugins);
                            if (project2.isDisposed()) {
                                return;
                            }
                            EditorNotifications.getInstance((Project)project2).updateAllNotifications();
                        }
                        HashMap<String, Plugin> ids = new HashMap<String, Plugin>();
                        for (UnknownFeature feature : unknownFeatures) {
                            ProgressManager.checkCanceled();
                            List<Plugin> pluginId = PluginsAdvertiser.retrieve(feature);
                            if (pluginId == null) continue;
                            for (Plugin plugin : pluginId) {
                                ids.put(plugin.myPluginId, plugin);
                                this.myFeatures.putValue((Object)plugin.myPluginId, (Object)feature);
                            }
                        }
                        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
                        for (String id : ids.keySet()) {
                            IdeaPluginDescriptor pluginDescriptor;
                            Plugin plugin = (Plugin)ids.get(id);
                            if (!disabledPlugins.contains(id) || (pluginDescriptor = PluginManager.getPlugin(PluginId.getId((String)id))) == null) continue;
                            this.myDisabledPlugins.put(plugin, pluginDescriptor);
                        }
                        this.myBundledPlugin = PluginsAdvertiser.hasBundledPluginToInstall(ids.values());
                        for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                            PluginId pluginId = loadedPlugin.getPluginId();
                            if (!ids.containsKey(pluginId.getIdString()) || disabledPlugins.contains(pluginId.getIdString()) || PluginManagerCore.isBrokenPlugin(loadedPlugin)) continue;
                            this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                        }
                        ApplicationManager.getApplication().invokeLater(this::onSuccess, ModalityState.NON_MODAL);
                    }
                    catch (Exception e2) {
                        LOG.info((Throwable)e2);
                    }
                }

                private void onSuccess() {
                    String message2 = null;
                    if (!this.myPlugins.isEmpty() || !this.myDisabledPlugins.isEmpty()) {
                        message2 = this.getAddressedMessagePresentation();
                        message2 = !this.myDisabledPlugins.isEmpty() ? message2 + "<a href=\"enable\">Enable plugins...</a><br>" : message2 + "<a href=\"configure\">Configure plugins...</a><br>";
                        message2 = message2 + "<a href=\"ignore\">Ignore Unknown Features</a>";
                    } else if (this.myBundledPlugin != null && !PropertiesComponent.getInstance().isTrueValue(PluginsAdvertiser.IGNORE_ULTIMATE_EDITION)) {
                        message2 = "Features covered by IntelliJ IDEA Ultimate Edition (" + StringUtil.join((Collection)this.myBundledPlugin, (String)", ") + ") are detected.<br><a href=\"open\">" + PluginsAdvertiser.CHECK_ULTIMATE_EDITION_TITLE + "</a><br><a href=\"ignoreUltimate\">" + PluginsAdvertiser.ULTIMATE_EDITION_SUGGESTION + "</a>";
                    }
                    if (message2 != null) {
                        ConfigurePluginsListener notificationListener = new ConfigurePluginsListener(unknownFeatures, project2, PluginManagerMain.mapToPluginIds(this.myAllPlugins), this.myPlugins, this.myDisabledPlugins);
                        NOTIFICATION_GROUP.createNotification(PluginsAdvertiser.DISPLAY_ID, message2, NotificationType.INFORMATION, (NotificationListener)notificationListener).notify(project2);
                    }
                }

                @NotNull
                private String getAddressedMessagePresentation() {
                    MultiMap addressedFeatures = MultiMap.createSet();
                    LinkedHashSet<String> ids = new LinkedHashSet<String>();
                    for (Object plugin : this.myPlugins) {
                        ids.add(((PluginDownloader)plugin).getPluginId());
                    }
                    for (Object plugin : this.myDisabledPlugins.keySet()) {
                        ids.add(((Plugin)plugin).myPluginId);
                    }
                    for (String id : ids) {
                        for (UnknownFeature feature : this.myFeatures.get((Object)id)) {
                            addressedFeatures.putValue((Object)feature.getFeatureDisplayName(), (Object)feature.getImplementationName());
                        }
                    }
                    String addressedFeaturesPresentation = StringUtil.join((Collection)addressedFeatures.entrySet(), entry -> (String)entry.getKey() + "[" + StringUtil.join((Collection)((Collection)entry.getValue()), (String)", ") + "]", (String)", ");
                    int addressedFeaturesNumber = addressedFeatures.keySet().size();
                    int pluginsNumber = ids.size();
                    String string2 = StringUtil.pluralize((String)"Plugin", (int)pluginsNumber) + " supporting " + StringUtil.pluralize((String)"feature", (int)addressedFeaturesNumber) + " (" + addressedFeaturesPresentation + ") " + (pluginsNumber == 1 ? "is" : "are") + " currently " + (this.myPlugins.isEmpty() ? "disabled" : "not installed") + ".<br>";
                    if (string2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$4", "getAddressedMessagePresentation"));
                    }
                    return string2;
                }
            });
        });
    }

    private static class ConfigurePluginsListener
    implements NotificationListener {
        private final Set<UnknownFeature> myUnknownFeatures;
        private final Project myProject;
        private final List<PluginId> myAllPlugins;
        private final Set<PluginDownloader> myPlugins;
        private final Map<Plugin, IdeaPluginDescriptor> myDisabledPlugins;

        public ConfigurePluginsListener(Set<UnknownFeature> unknownFeatures, Project project2, List<PluginId> allPlugins, Set<PluginDownloader> plugins2, Map<Plugin, IdeaPluginDescriptor> disabledPlugins) {
            this.myUnknownFeatures = unknownFeatures;
            this.myProject = project2;
            this.myAllPlugins = allPlugins;
            this.myPlugins = plugins2;
            this.myDisabledPlugins = disabledPlugins;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$ConfigurePluginsListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$ConfigurePluginsListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("ignore".equals(description)) {
                    UnknownFeaturesCollector featuresCollector = UnknownFeaturesCollector.getInstance(this.myProject);
                    for (UnknownFeature feature : this.myUnknownFeatures) {
                        featuresCollector.ignoreFeature(feature);
                    }
                    notification.expire();
                } else if ("configure".equals(description)) {
                    LOG.assertTrue(this.myAllPlugins != null);
                    notification.expire();
                    new PluginsAdvertiserDialog(this.myProject, this.myPlugins.toArray(new PluginDownloader[this.myPlugins.size()]), this.myAllPlugins).show();
                } else if ("enable".equals(description)) {
                    PluginsAdvertiser.enablePlugins(this.myProject, this.myDisabledPlugins.values());
                    notification.expire();
                } else if ("ignoreUltimate".equals(description)) {
                    PropertiesComponent.getInstance().setValue(PluginsAdvertiser.IGNORE_ULTIMATE_EDITION, "true");
                    notification.expire();
                } else if ("open".equals(description)) {
                    PluginsAdvertiser.openDownloadPage();
                    notification.expire();
                }
            }
        }
    }

    @Tag(value="plugin")
    public static class Plugin
    implements Comparable<Plugin> {
        public String myPluginId;
        public String myPluginName;
        public boolean myBundled;

        public Plugin(PluginId pluginId, String pluginName, boolean bundled) {
            this.myPluginId = pluginId.getIdString();
            this.myBundled = bundled;
            this.myPluginName = pluginName;
        }

        public Plugin() {
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Plugin plugin = (Plugin)o2;
            if (this.myBundled != plugin.myBundled) {
                return false;
            }
            if (!this.myPluginId.equals(plugin.myPluginId)) {
                return false;
            }
            return this.myPluginName == null || this.myPluginName.equals(plugin.myPluginName);
        }

        public int hashCode() {
            int result2 = this.myPluginId.hashCode();
            result2 = 31 * result2 + (this.myBundled ? 1 : 0);
            result2 = 31 * result2 + (this.myPluginName != null ? this.myPluginName.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Plugin other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$Plugin", "compareTo"));
            }
            if (this.myBundled && !other.myBundled) {
                return -1;
            }
            if (!this.myBundled && other.myBundled) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)this.myPluginId), (Comparable)((Object)other.myPluginId));
        }
    }

    @Tag(value="plugins")
    public static class PluginSet {
        public Set<Plugin> myPlugins = new HashSet<Plugin>();

        public PluginSet() {
        }

        public PluginSet(Set<Plugin> plugins2) {
            for (Plugin plugin : plugins2) {
                this.myPlugins.add(plugin);
            }
        }
    }

    @Tag(value="exts")
    public static class KnownExtensions {
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PluginSet> myExtensions = new HashMap<String, PluginSet>();

        public KnownExtensions() {
        }

        public KnownExtensions(Map<String, Set<Plugin>> extensions) {
            for (String ext : extensions.keySet()) {
                this.myExtensions.put(ext, new PluginSet(extensions.get(ext)));
            }
        }

        public Set<Plugin> find(String extension) {
            PluginSet pluginSet = this.myExtensions.get(extension);
            if (pluginSet != null) {
                return pluginSet.myPlugins;
            }
            return null;
        }
    }
}

