/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultCaret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposerDebugger
implements UiDebuggerExtension,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.objectTree.DisposerDebugger");
    private JComponent myComponent;
    private JBTabsImpl myTreeTabs;

    private void initUi() {
        this.myComponent = new JPanel();
        this.myTreeTabs = new JBTabsImpl(null, null, (Disposable)this);
        Splitter splitter = new Splitter(true);
        JBTabsImpl bottom = new JBTabsImpl(null, null, (Disposable)this);
        AllocationPanel allocations = new AllocationPanel((JBTabs)this.myTreeTabs);
        bottom.addTab(new TabInfo((JComponent)allocations).setText("Allocation")).setActions(allocations.getActions(), "unknown");
        splitter.setFirstComponent((JComponent)this.myTreeTabs);
        splitter.setSecondComponent((JComponent)bottom);
        this.myComponent.setLayout(new BorderLayout());
        this.myComponent.add((Component)splitter, "Center");
        JLabel countLabel = new JLabel("Total disposable count: " + Disposer.getTree().size());
        this.myComponent.add((Component)countLabel, "South");
        this.addTree(new DisposerTree(this), "All", false);
        this.addTree(new DisposerTree(this), "Watch", true);
    }

    private void addTree(DisposerTree tree2, String name, boolean canClear) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (canClear) {
            group.add((AnAction)new ClearAction(tree2));
        }
        this.myTreeTabs.addTab(new TabInfo((JComponent)tree2).setText(name).setObject((Object)tree2).setActions((ActionGroup)group, "unknown"));
    }

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.initUi();
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Disposer";
    }

    public void dispose() {
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
    }

    private static class DisposerNode
    extends AbstractTreeNode<ObjectNode> {
        private final DisposerTree myTree;

        private DisposerNode(DisposerTree tree2, ObjectNode value2) {
            super(null, (Object)value2);
            this.myTree = tree2;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ObjectNode value2 = (ObjectNode)this.getValue();
            if (value2 != null) {
                Collection subnodes = value2.getChildren();
                ArrayList<DisposerNode> children2 = new ArrayList<DisposerNode>(subnodes.size());
                for (Object subnode : subnodes) {
                    children2.add(new DisposerNode(this.myTree, (ObjectNode)subnode));
                }
                ArrayList<DisposerNode> arrayList = children2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerNode", "getChildren"));
                }
                return arrayList;
            }
            ObjectTree tree2 = Disposer.getTree();
            Set root = tree2.getRootObjects();
            ArrayList<DisposerNode> children3 = new ArrayList<DisposerNode>(root.size());
            for (Disposable each : root) {
                children3.add(new DisposerNode(this.myTree, tree2.getNode((Object)each)));
            }
            ArrayList<DisposerNode> arrayList = children3;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerNode", "getChildren"));
            }
            return arrayList;
        }

        @Nullable
        public Throwable getAllocation() {
            return this.getValue() != null ? ((ObjectNode)this.getValue()).getAllocation() : null;
        }

        protected boolean shouldUpdateData() {
            return true;
        }

        protected void update(PresentationData presentation) {
            if (this.getValue() != null) {
                String fqNameClass;
                String fqNameObject;
                int dogIndex;
                Object object = ((ObjectNode)this.getValue()).getObject();
                String classString = object.getClass().toString();
                String objectString = object.toString();
                presentation.setPresentableText(objectString);
                if (((ObjectNode)this.getValue()).getOwnModification() < this.myTree.myModificationToFilter) {
                    presentation.setForcedTextForeground((Color)JBColor.GRAY);
                }
                if (objectString != null && (dogIndex = objectString.lastIndexOf("@")) >= 0 && (fqNameObject = objectString.substring(0, dogIndex)).equals(fqNameClass = classString.substring("class ".length()))) {
                    return;
                }
                presentation.setLocationString(classString);
            }
        }
    }

    private static class DisposerStructure
    extends AbstractTreeStructureBase {
        private final DisposerNode myRoot;

        private DisposerStructure(DisposerTree tree2) {
            super(null);
            this.myRoot = new DisposerNode(tree2, null);
        }

        @Override
        public List<TreeStructureProvider> getProviders() {
            return null;
        }

        public Object getRootElement() {
            return this.myRoot;
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }
    }

    private static class DisposerTree
    extends JPanel
    implements Disposable,
    ObjectTreeListener,
    ElementFilter<DisposerNode> {
        private final FilteringTreeBuilder myTreeBuilder;
        private final Tree myTree;
        private long myModificationToFilter = -1L;

        private DisposerTree(Disposable parent) {
            final DisposerStructure structure = new DisposerStructure(this);
            DefaultTreeModel model2 = new DefaultTreeModel(new DefaultMutableTreeNode());
            Tree tree2 = new Tree((TreeModel)model2);
            tree2.setRootVisible(false);
            tree2.setShowsRootHandles(true);
            tree2.getSelectionModel().setSelectionMode(1);
            this.myTreeBuilder = new FilteringTreeBuilder(tree2, this, structure, (Comparator)AlphaComparator.INSTANCE){

                public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                    return structure.getRootElement() == this.getOriginalNode(nodeDescriptor);
                }
            };
            this.myTreeBuilder.setFilteringMerge(200, MergingUpdateQueue.ANY_COMPONENT);
            Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
            this.myTree = tree2;
            this.setLayout(new BorderLayout());
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
            Disposer.getTree().addListener((ObjectTreeListener)this);
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        public boolean shouldBeShowing(DisposerNode value2) {
            return ((ObjectNode)value2.getValue()).getModification() > this.myModificationToFilter;
        }

        public void objectRegistered(@NotNull Object node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerTree", "objectRegistered"));
            }
            this.queueUpdate();
        }

        public void objectExecuted(@NotNull Object node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/util/objectTree/DisposerDebugger$DisposerTree", "objectExecuted"));
            }
            this.queueUpdate();
        }

        private void queueUpdate() {
            UIUtil.invokeLaterIfNeeded(() -> this.myTreeBuilder.refilter());
        }

        public void dispose() {
            Disposer.getTree().removeListener((ObjectTreeListener)this);
        }

        @Nullable
        public DisposerNode getSelectedNode() {
            Set nodes = this.myTreeBuilder.getSelectedElements(DisposerNode.class);
            return nodes.size() == 1 ? (DisposerNode)((Object)nodes.iterator().next()) : null;
        }

        public Tree getTree() {
            return this.myTree;
        }

        public void clear() {
            this.myModificationToFilter = Disposer.getTree().getModification();
            this.myTreeBuilder.refilter();
        }
    }

    private static class AllocationPanel
    extends JPanel
    implements TreeSelectionListener {
        private final JEditorPane myAllocation;
        private final DefaultActionGroup myActions;
        private final JBTabs myTreeTabs;

        private AllocationPanel(JBTabs treeTabs) {
            this.myTreeTabs = treeTabs;
            this.myAllocation = new JEditorPane();
            DefaultCaret caret = new DefaultCaret();
            this.myAllocation.setCaret(caret);
            caret.setUpdatePolicy(1);
            this.myAllocation.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myAllocation), "Center");
            treeTabs.addListener((TabsListener)new TabsListener.Adapter(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    this.updateText();
                }

                public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    this.removeListener(oldSelection);
                    this.addListener(newSelection);
                }
            });
            this.myActions = new DefaultActionGroup();
            this.myActions.add((AnAction)new CopyAllocationAction());
        }

        private void addListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().addTreeSelectionListener(this);
        }

        private void removeListener(TabInfo info) {
            if (info == null) {
                return;
            }
            ((DisposerTree)info.getObject()).getTree().getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e2) {
            this.updateText();
        }

        private void updateText() {
            Throwable allocation;
            if (this.myTreeTabs.getSelectedInfo() == null) {
                return;
            }
            DisposerTree tree2 = (DisposerTree)this.myTreeTabs.getSelectedInfo().getObject();
            DisposerNode node = tree2.getSelectedNode();
            if (node != null && (allocation = node.getAllocation()) != null) {
                StringWriter s2 = new StringWriter();
                PrintWriter writer = new PrintWriter(s2);
                allocation.printStackTrace(writer);
                this.myAllocation.setText(s2.toString());
                return;
            }
            this.myAllocation.setText(null);
        }

        public ActionGroup getActions() {
            return this.myActions;
        }

        private class CopyAllocationAction
        extends AnAction {
            public CopyAllocationAction() {
                super("Copy", "Copy allocation to clipboard", PlatformIcons.COPY_ICON);
            }

            public void update(AnActionEvent e2) {
                e2.getPresentation().setEnabled(AllocationPanel.this.myAllocation.getDocument().getLength() > 0);
            }

            public void actionPerformed(AnActionEvent e2) {
                try {
                    CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(AllocationPanel.this.myAllocation.getText()));
                }
                catch (HeadlessException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }
    }

    private static class ClearAction
    extends AnAction {
        private final DisposerTree myTree;

        private ClearAction(DisposerTree tree2) {
            super("Clear");
            this.myTree = tree2;
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setIcon(AllIcons.Debugger.Watch);
        }

        public void actionPerformed(AnActionEvent e2) {
            this.myTree.clear();
        }
    }
}

