/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenProjectSetProcessor
extends ProjectSetProcessor {
    public String getId() {
        return "project";
    }

    public void processEntries(@NotNull List<Pair<String, String>> entries, @NotNull ProjectSetProcessor.Context context2, @NotNull Runnable runNext) {
        Project project2;
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        if (runNext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runNext", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "processEntries"));
        }
        String root = context2.directory == null || context2.directoryName == null ? null : context2.directory.getPath() + "/" + context2.directoryName;
        for (Pair<String, String> entry : entries) {
            if (!"project".equals(entry.getFirst())) continue;
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/OpenProjectSetProcessor", "lambda$processEntries$0"));
                }
                String path = root == null ? (String)entry.getSecond() : root + "/" + (String)entry.getSecond();
                context2.project = ProjectUtil.openProject(path, null, true);
            });
            if (context2.project != null) {
                runNext.run();
            }
            return;
        }
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (dir != null && (project2 = PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false)) != null) {
            runNext.run();
        }
    }
}

