/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsCheckoutProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsProjectSetProcessor
extends ProjectSetProcessor {
    private static final Logger LOG = Logger.getInstance(VcsProjectSetProcessor.class);

    public String getId() {
        return "vcs";
    }

    public void processEntries(final @NotNull List<Pair<String, String>> entries, final @NotNull ProjectSetProcessor.Context context2, final @NotNull Runnable runNext) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (runNext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runNext", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (!VcsProjectSetProcessor.getDirectory(context2)) {
            return;
        }
        if (!VcsProjectSetProcessor.getDirectoryName(context2)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Hey", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/VcsProjectSetProcessor$1", "run"));
                }
                for (Pair pair : entries) {
                    String vcs = (String)pair.getFirst();
                    VcsCheckoutProcessor processor2 = VcsCheckoutProcessor.getProcessor((String)vcs);
                    if (processor2 == null) {
                        LOG.error("Checkout processor not found for " + vcs);
                        return;
                    }
                    JsonElement element = new JsonParser().parse((String)pair.getSecond());
                    HashMap parameters = new HashMap();
                    for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                        JsonElement value2 = (JsonElement)entry.getValue();
                        parameters.put(entry.getKey(), value2 instanceof JsonPrimitive ? value2.getAsString() : value2.toString());
                    }
                    String directoryName = context2.directoryName;
                    if (parameters.get("targetDir") != null) {
                        directoryName = directoryName + "/" + (String)parameters.get("targetDir");
                    }
                    if (processor2.checkout(parameters, context2.directory, directoryName)) continue;
                    return;
                }
                runNext.run();
            }
        });
    }

    private static boolean getDirectoryName(@NotNull ProjectSetProcessor.Context context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "getDirectoryName"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            context2.directoryName = "test";
            return true;
        }
        context2.directoryName = Messages.showInputDialog((Project)null, (String)("Enter directory name for created project. Leave blank to checkout directly into \"" + context2.directory.getName() + "\"."), (String)"Project Directory Name", null, (String)context2.directoryName, null);
        return context2.directoryName != null;
    }

    private static boolean getDirectory(@NotNull ProjectSetProcessor.Context context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "getDirectory"));
        }
        if (context2.directory != null) {
            return true;
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor2.setTitle("Select Destination Folder");
        descriptor2.setDescription("");
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null);
        context2.directory = files2.length == 0 ? null : files2[0];
        return context2.directory != null;
    }
}

